<?php

namespace Tests\Feature;

use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class UserSidebarTest extends TestCase
{
    use RefreshDatabase;

    public function test_user_profile_sidebar_is_rendered_in_sidepanel_mode(): void
    {
        $authUser = User::factory()->create(['role' => 'admin']);
        $manager = User::factory()->create([
            'name' => 'Maria Curator',
        ]);
        $member = User::factory()->create([
            'name' => 'Ivan Petrov',
            'role' => 'manager',
            'phone' => '+7 999 000-00-00',
            'job_title' => 'Project Manager',
            'manager_id' => $manager->id,
            'birth_date' => '1992-01-12',
        ]);

        $this->actingAs($authUser)
            ->get(route('users.show', ['member' => $member]).'?sidepanel=1')
            ->assertOk()
            ->assertSee('data-sidepanel-entity="user"', false)
            ->assertSee('Ivan Petrov')
            ->assertSee('Project Manager')
            ->assertSee('Maria Curator')
            ->assertSee('12.01.1992')
            ->assertSee('Open profile')
            ->assertSee('Request remote access');
    }

    public function test_user_profile_page_is_rendered_outside_sidepanel(): void
    {
        $authUser = User::factory()->create(['role' => 'admin']);
        $member = User::factory()->create([
            'name' => 'Anna Smirnova',
            'role' => 'sales',
        ]);

        $this->actingAs($authUser)
            ->get(route('users.show', ['member' => $member]))
            ->assertOk()
            ->assertSee('Anna Smirnova')
            ->assertSee('User')
            ->assertSee('Request remote access');
    }
}
