<?php

namespace Tests\Feature;

use App\Http\Middleware\TranslateHtmlStrings;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Tests\TestCase;

class TranslateHtmlStringsTest extends TestCase
{
    public function test_it_preserves_alpine_x_data_attributes_with_greater_than(): void
    {
        app()->setLocale('ru');

        $middleware = new TranslateHtmlStrings();
        $request = Request::create('/translate-test', 'GET');
        $response = new Response(
            '<div x-data="{ foo: bar > baz }"><span>News</span></div>',
            200,
            ['Content-Type' => 'text/html']
        );

        $handled = $middleware->handle($request, fn () => $response);
        $content = (string) $handled->getContent();

        $this->assertStringContainsString('x-data="{ foo: bar > baz }"', $content);
    }
}
