<?php

namespace Tests\Feature;

use App\Models\OrganizationSetting;
use App\Models\Theme;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ThemeManagementTest extends TestCase
{
    use RefreshDatabase;

    public function test_admin_can_create_and_activate_theme(): void
    {
        $admin = User::factory()->create(['role' => 'admin']);

        $payload = [
            'name' => 'Oceanic',
            'slug' => 'oceanic',
            'palette' => [
                'primary' => '#123456',
                'accent' => '#0EA5E9',
            ],
            'fonts' => [
                'body' => 'Figtree, ui-sans-serif',
                'heading' => 'Figtree, ui-sans-serif',
            ],
            'icons' => [
                'color' => '#334155',
            ],
        ];

        $this->actingAs($admin)
            ->post(route('profile.themes.store'), $payload)
            ->assertRedirect(route('profile.edit', ['section' => 'themes']));

        $theme = Theme::query()->where('slug', 'oceanic')->firstOrFail();

        $this->actingAs($admin)
            ->patch(route('profile.themes.activate', ['theme' => $theme->id]))
            ->assertRedirect(route('profile.edit', ['section' => 'themes']));

        $setting = OrganizationSetting::current();
        $this->assertSame($theme->id, $setting->theme_id);
    }
}

