<?php

namespace Tests\Feature;

use App\Models\OrganizationCompany;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class SidebarBrandingTest extends TestCase
{
    use RefreshDatabase;

    public function test_sidebar_brand_uses_company_name_and_logo_when_available(): void
    {
        $company = OrganizationCompany::query()->create([
            'name' => 'CRM25 Holding',
            'logo_path' => 'organization-logos/crm25-holding.png',
            'sort_order' => 0,
        ]);

        $user = User::factory()->create([
            'role' => 'admin',
            'organization_company_id' => $company->id,
        ]);

        $this->actingAs($user)
            ->get(route('dashboard'))
            ->assertOk()
            ->assertSee('CRM25 Holding')
            ->assertSee('/storage/organization-logos/crm25-holding.png');
    }
}

