<?php

namespace Tests\Feature;

use App\Models\User;
use App\Support\TwoFactorAuthenticator;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Illuminate\Support\Carbon;
use Tests\TestCase;

class ProfileTwoFactorTest extends TestCase
{
    use RefreshDatabase;

    public function test_user_can_enable_and_disable_two_factor_from_profile_settings(): void
    {
        Carbon::setTestNow('2026-02-27 12:00:00');

        try {
            $twoFactorAuthenticator = app(TwoFactorAuthenticator::class);
            $user = User::factory()->create();

            $setupResponse = $this->actingAs($user)->post('/profile/two-factor/setup');
            $setupResponse->assertRedirect();
            $setupResponse->assertSessionHas('two_factor.pending.secret');

            $secret = (string) session('two_factor.pending.secret');
            $code = $twoFactorAuthenticator->currentCode($secret);

            $confirmResponse = $this->actingAs($user)->post('/profile/two-factor/confirm', [
                'code' => $code,
            ]);

            $confirmResponse->assertRedirect();
            $confirmResponse->assertSessionHasNoErrors();

            $user->refresh();

            $this->assertTrue($user->hasTwoFactorEnabled());
            $this->assertIsArray($user->two_factor_recovery_codes);
            $this->assertCount(8, $user->two_factor_recovery_codes);

            $disableResponse = $this->actingAs($user)->delete('/profile/two-factor');
            $disableResponse->assertRedirect();

            $user->refresh();

            $this->assertFalse($user->hasTwoFactorEnabled());
            $this->assertNull($user->two_factor_secret);
            $this->assertNull($user->two_factor_recovery_codes);
        } finally {
            Carbon::setTestNow();
        }
    }
}
