<?php

namespace Tests\Feature;

use App\Models\DealStage;
use App\Models\Pipeline;
use App\Models\User;
use Database\Seeders\ProductionBootstrapSeeder;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class ProductionBootstrapSeederTest extends TestCase
{
    use RefreshDatabase;

    public function test_production_bootstrap_seeder_creates_admin_and_default_pipeline(): void
    {
        config([
            'app.url' => 'https://crm25.example.test',
        ]);

        putenv('APP_URL=https://crm25.example.test');
        putenv('CRM_BOOTSTRAP_ADMIN_EMAIL=admin@crm25.example.test');
        putenv('CRM_BOOTSTRAP_ADMIN_PASSWORD=InstallPass123');
        putenv('CRM_BOOTSTRAP_ADMIN_NAME=Primary Administrator');

        $this->seed(ProductionBootstrapSeeder::class);

        $admin = User::query()->where('email', 'admin@crm25.example.test')->first();

        $this->assertNotNull($admin);
        $this->assertSame('admin', $admin?->role);
        $this->assertSame('Primary Administrator', $admin?->name);
        $this->assertSame('ru', $admin?->locale);
        $this->assertTrue(password_verify('InstallPass123', (string) $admin?->password));

        $pipeline = Pipeline::query()->where('is_default', true)->first();

        $this->assertNotNull($pipeline);
        $this->assertSame('Primary Sales', $pipeline?->name);
        $this->assertSame($admin?->id, $pipeline?->creator_id);

        $this->assertSame(6, DealStage::query()->where('pipeline_id', $pipeline?->id)->count());
        $this->assertTrue(DealStage::query()->where('pipeline_id', $pipeline?->id)->where('code', 'won')->where('is_won', true)->exists());
        $this->assertTrue(DealStage::query()->where('pipeline_id', $pipeline?->id)->where('code', 'lost')->where('is_lost', true)->exists());
    }

    protected function tearDown(): void
    {
        putenv('APP_URL');
        putenv('CRM_BOOTSTRAP_ADMIN_EMAIL');
        putenv('CRM_BOOTSTRAP_ADMIN_PASSWORD');
        putenv('CRM_BOOTSTRAP_ADMIN_NAME');

        parent::tearDown();
    }
}
