<?php

namespace Tests\Feature;

use App\Models\OneCSetting;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class OneCFeatureTest extends TestCase
{
    use RefreshDatabase;

    public function test_admin_can_open_one_c_section_and_create_exchange_entry(): void
    {
        $admin = User::factory()->create([
            'role' => 'admin',
        ]);

        OneCSetting::query()->create([
            'provider' => '1c',
            'is_active' => true,
            'exchange_mode' => 'bidirectional',
            'sync_interval_minutes' => 15,
        ]);

        $this->actingAs($admin)
            ->get(route('onec.index'))
            ->assertOk()
            ->assertSee('1C Integration')
            ->assertSee('Exchange log');

        $this->actingAs($admin)
            ->post(route('onec.exchanges.store'), [
                'external_id' => 'onec-ex-1001',
                'direction' => 'outbound',
                'entity' => 'deals',
                'action' => 'upsert',
                'status' => 'queued',
                'payload' => '{"deal_id":101}',
                'response' => '{"status":"queued"}',
                'meta' => '{"source":"test"}',
                'initiated_by_user_id' => $admin->id,
            ])
            ->assertRedirect(route('onec.index'));

        $this->assertDatabaseHas('one_c_exchanges', [
            'external_id' => 'onec-ex-1001',
            'direction' => 'outbound',
            'entity' => 'deals',
            'action' => 'upsert',
            'status' => 'queued',
            'initiated_by_user_id' => $admin->id,
        ]);
    }

    public function test_regular_user_cannot_open_one_c_section_by_default(): void
    {
        $user = User::factory()->create([
            'role' => 'user',
        ]);

        $this->actingAs($user)
            ->get(route('onec.index'))
            ->assertForbidden();
    }
}

