<?php

namespace Tests\Feature;

use App\Models\User;
use App\Support\MenuManager;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class MenuNewsOrderTest extends TestCase
{
    use RefreshDatabase;

    public function test_news_core_menu_item_is_inserted_as_first_item(): void
    {
        $user = User::factory()->create();

        $user->menuItems()->create([
            'key' => 'dashboard',
            'icon' => 'home',
            'sort_order' => 0,
            'is_visible' => true,
            'is_custom' => false,
        ]);

        $user->menuItems()->create([
            'key' => 'companies',
            'icon' => 'building',
            'sort_order' => 1,
            'is_visible' => true,
            'is_custom' => false,
        ]);

        app(MenuManager::class)->ensureCoreItems($user);

        $orderedCoreKeys = $user->fresh()
            ->menuItems()
            ->where('is_custom', false)
            ->orderBy('sort_order')
            ->orderBy('id')
            ->pluck('key')
            ->values()
            ->all();

        $this->assertSame('news', $orderedCoreKeys[0] ?? null);
    }

    public function test_default_core_menu_order_starts_with_business_sections_sequence(): void
    {
        $user = User::factory()->create([
            'role' => 'admin',
        ]);

        app(MenuManager::class)->ensureCoreItems($user);

        $orderedCoreKeys = $user->fresh()
            ->menuItems()
            ->where('is_custom', false)
            ->orderBy('sort_order')
            ->orderBy('id')
            ->pluck('key')
            ->values()
            ->all();

        $expectedPrefix = [
            'news',
            'tasks',
            'projects',
            'calendar',
            'disks',
            'deals',
            'pipelines',
            'companies',
            'contacts',
            'forms',
            'products',
            'warehouses',
            'activities',
            'reports',
            'messengers',
        ];

        $this->assertSame($expectedPrefix, array_slice($orderedCoreKeys, 0, count($expectedPrefix)));
    }
}
