<?php

namespace Tests\Feature;

use App\Models\MailServiceSetting;
use App\Models\User;
use Illuminate\Foundation\Testing\RefreshDatabase;
use Tests\TestCase;

class MailServiceFeatureTest extends TestCase
{
    use RefreshDatabase;

    public function test_admin_can_open_mail_section_and_issue_mailbox(): void
    {
        $admin = User::factory()->create([
            'role' => 'admin',
        ]);

        MailServiceSetting::query()->create([
            'provider' => 'manual',
            'is_active' => true,
            'domain' => 'mail.crm.local',
            'auto_provision_on_registration' => true,
            'auto_provision_on_user_create' => true,
            'default_status' => 'active',
            'default_quota_mb' => 2048,
        ]);

        $this->actingAs($admin)
            ->get(route('mail.index'))
            ->assertOk()
            ->assertSee('Mail Service')
            ->assertSee('Mailboxes');

        $this->actingAs($admin)
            ->post(route('mail.mailboxes.store'), [
                'user_id' => $admin->id,
                'local_part' => 'crm.admin',
                'domain' => 'mail.crm.local',
                'status' => 'active',
                'is_primary' => 1,
                'quota_mb' => 1024,
                'used_mb' => 10,
            ])
            ->assertRedirect(route('mail.index'));

        $this->assertDatabaseHas('mailboxes', [
            'user_id' => $admin->id,
            'address' => 'crm.admin@mail.crm.local',
        ]);
    }

    public function test_regular_user_cannot_open_mail_section_by_default(): void
    {
        $user = User::factory()->create([
            'role' => 'user',
        ]);

        $this->actingAs($user)
            ->get(route('mail.index'))
            ->assertForbidden();
    }
}

