<?php

namespace Tests\Feature;

use Tests\TestCase;

class InstallerMigrationCompatibilityTest extends TestCase
{
    public function test_initial_crm_foreign_keys_are_not_forward_references(): void
    {
        $dealStagesMigration = file_get_contents(database_path('migrations/2026_02_27_033106_create_deal_stages_table.php'));
        $dealsMigration = file_get_contents(database_path('migrations/2026_02_27_033106_create_deals_table.php'));
        $foreignKeysMigration = file_get_contents(database_path('migrations/2026_02_28_239000_add_initial_crm_foreign_keys.php'));

        $this->assertIsString($dealStagesMigration);
        $this->assertIsString($dealsMigration);
        $this->assertIsString($foreignKeysMigration);

        $this->assertStringNotContainsString("constrained('pipelines')", $dealStagesMigration);
        $this->assertStringNotContainsString("constrained('pipelines')", $dealsMigration);
        $this->assertStringNotContainsString("constrained('deal_stages')", $dealsMigration);

        $this->assertStringContainsString('deal_stages_pipeline_id_foreign', $foreignKeysMigration);
        $this->assertStringContainsString('deals_pipeline_id_foreign', $foreignKeysMigration);
        $this->assertStringContainsString('deals_stage_id_foreign', $foreignKeysMigration);
    }
}
