<?php

use App\Models\Project;
use App\Models\Task;
use App\Models\User;
use Illuminate\Support\Facades\Broadcast;
use Illuminate\Support\Facades\Gate;

Broadcast::channel('App.Models.User.{id}', function ($user, $id) {
    return (int) $user->id === (int) $id;
});

Broadcast::channel('projects.{projectId}', function (User $user, int $projectId): bool {
    $project = Project::query()->find($projectId);

    if (! $project) {
        return false;
    }

    return Gate::forUser($user)->allows('view', $project);
});

Broadcast::channel('tasks.board', function (User $user): bool {
    return Gate::forUser($user)->allows('viewAny', Task::class);
});
