<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <div class="min-w-0">
                <h2 class="truncate text-xl font-semibold leading-tight text-gray-900">{{ $member->name }}</h2>
                <p class="text-sm text-slate-500">{{ $roleLabel }}</p>
            </div>
            @if ($canRequestRemoteAccess)
                <div class="flex flex-wrap items-center gap-2">
                    @if ($latestRemoteAccessRequest && $latestRemoteAccessRequest->status === 'requested')
                        <span class="inline-flex items-center rounded-full border border-amber-200 bg-amber-50 px-3 py-1.5 text-xs font-medium text-amber-700">
                            {{ __('Request sent') }}
                        </span>
                    @elseif ($latestRemoteAccessRequest && $latestRemoteAccessRequest->status === 'approved')
                        <span class="inline-flex items-center rounded-full border border-emerald-200 bg-emerald-50 px-3 py-1.5 text-xs font-medium text-emerald-700">
                            {{ __('Approved') }}
                        </span>
                    @elseif ($latestRemoteAccessRequest && $latestRemoteAccessRequest->status === 'declined')
                        <span class="inline-flex items-center rounded-full border border-rose-200 bg-rose-50 px-3 py-1.5 text-xs font-medium text-rose-700">
                            {{ __('Declined') }}
                        </span>
                    @endif

                    <form method="POST" action="{{ route('users.remote-access-requests.store', ['member' => $member]) }}">
                        @csrf
                        <input type="hidden" name="redirect_to" value="{{ url()->current() }}">
                        <button
                            type="submit"
                            class="inline-flex items-center rounded-md border border-slate-300 bg-white px-4 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50"
                            @disabled($latestRemoteAccessRequest && $latestRemoteAccessRequest->status === 'requested')
                        >
                            {{ __('Request remote access') }}
                        </button>
                    </form>

                    @if ($latestRemoteAccessRequest && $latestRemoteAccessRequest->status === 'approved')
                        <a
                            href="{{ route('remote-access-requests.show', $latestRemoteAccessRequest) }}"
                            class="inline-flex items-center rounded-md bg-emerald-600 px-4 py-2 text-sm font-medium text-white hover:bg-emerald-500"
                        >
                            {{ __('Open remote session') }}
                        </a>
                    @endif

                    <a href="{{ route('chat.sidebar', ['member' => $member]) }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">
                        {{ __('Open chat') }}
                    </a>
                </div>
            @endif
        </div>
    </x-slot>

    <div class="w-full px-6 pb-12 pt-2" data-sidepanel-scope>
        @include('sidepanel.users.show', [
            'member' => $member,
            'recentDeals' => $recentDeals,
            'recentTasks' => $recentTasks,
            'recentProjects' => $recentProjects,
            'isOnline' => $isOnline,
            'roleLabel' => $roleLabel,
            'photoUrl' => $photoUrl,
            'photoStyle' => $photoStyle,
            'initials' => $initials,
        ])
    </div>
</x-app-layout>
