@php
    $statusLabels = [
        'todo' => __('To do'),
        'in_progress' => __('In progress'),
        'review' => __('Review'),
        'done' => __('Done'),
    ];

    $priorityLabels = [
        'low' => __('Low'),
        'medium' => __('Medium'),
        'high' => __('High'),
        'urgent' => __('Urgent'),
    ];
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight" data-task-live-title data-task-id="{{ $task->id }}">#{{ $task->id }} · {{ $task->title }}</h2>
                <p class="text-sm text-gray-500" data-task-live-meta data-task-id="{{ $task->id }}">{{ $statusLabels[$task->status] ?? $task->status }} · {{ $priorityLabels[$task->priority] ?? $task->priority }}</p>
            </div>
            <div class="flex items-center gap-2">
                <a href="{{ route('tasks.create', ['parent_id' => $task->id, 'project_id' => $task->project_id]) }}" class="inline-flex items-center rounded-md border border-gray-300 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50">New subtask</a>
            </div>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-4">
            <div class="bg-white border border-gray-200 rounded-xl p-6 space-y-4" data-task-live-root>
                <div class="grid grid-cols-1 gap-3 text-sm md:grid-cols-3">
                    <div>
                        <p class="text-gray-500">Stage Director</p>
                        <p class="font-medium text-gray-900">{{ $task->creator?->name ?? '—' }}</p>
                    </div>
                    <div>
                        <p class="text-gray-500">Subtasks</p>
                        <p class="font-medium text-gray-900">{{ $subtaskStats['done'] }} / {{ $subtaskStats['total'] }} ({{ $subtaskStats['progress'] }}%)</p>
                    </div>
                    <div>
                        <p class="text-gray-500">Current artist</p>
                        <p class="font-medium text-gray-900">{{ $task->assignee?->name ?? '—' }}</p>
                    </div>
                </div>

                @if ($subtaskStats['total'] > 0)
                    <div>
                        <div class="h-2 rounded-full bg-gray-100">
                            <div class="h-2 rounded-full bg-indigo-500" style="width: {{ $subtaskStats['progress'] }}%;"></div>
                        </div>
                    </div>
                @endif

                @include('tasks._live-editor', ['liveContext' => 'page'])
            </div>

            <section class="bg-white border border-gray-200 rounded-xl overflow-hidden">
                <div class="px-6 py-4 border-b border-gray-100 flex items-center justify-between gap-3">
                    <h3 class="font-semibold text-gray-900">Subtasks</h3>
                    <a href="{{ route('tasks.create', ['parent_id' => $task->id, 'project_id' => $task->project_id]) }}" class="text-sm text-indigo-600 hover:text-indigo-500">Add a subtask</a>
                </div>

                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Subtask</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Executor</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Term</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 bg-white">
                        @forelse ($subtasks as $subtask)
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3">
                                    <a href="{{ route('tasks.show', $subtask) }}" class="font-medium text-gray-900 hover:text-indigo-600">#{{ $subtask->id }} · {{ $subtask->title }}</a>
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $subtask->assignee?->name ?? '—' }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $subtask->due_at?->format('d.m H:i') ?? '—' }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $statusLabels[$subtask->status] ?? $subtask->status }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-4 py-8 text-center text-sm text-gray-500">There are no subtasks yet.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </section>
        </div>
    </div>
</x-app-layout>
