<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Reports and analytics</h2>
            <div class="text-sm text-gray-500">Updated: {{ now()->format('d.m.Y H:i') }}</div>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-6">
            <section class="grid grid-cols-1 md:grid-cols-2 xl:grid-cols-3 gap-4">
                <article class="bg-white border border-gray-200 rounded-xl p-5">
                    <p class="text-sm text-gray-500">Deals in progress</p>
                    <p class="mt-2 text-3xl font-semibold text-gray-900">{{ number_format($crm['deals_open']) }}</p>
                    <p class="mt-1 text-xs text-gray-500">Total: {{ number_format($crm['deals_total']) }} · Successfully: {{ number_format($crm['deals_won']) }} · Failed: {{ number_format($crm['deals_lost']) }}</p>
                </article>

                <article class="bg-white border border-gray-200 rounded-xl p-5">
                    <p class="text-sm text-gray-500">Active funnel volume</p>
                    <p class="mt-2 text-3xl font-semibold text-gray-900">${{ number_format((float) $crm['pipeline_value'], 0, '.', ' ') }}</p>
                    <p class="mt-1 text-xs text-gray-500">Successes this month: ${{ number_format((float) $crm['won_month_value'], 0, '.', ' ') }}</p>
                </article>

                <article class="bg-white border border-gray-200 rounded-xl p-5">
                    <p class="text-sm text-gray-500">Projects</p>
                    <p class="mt-2 text-3xl font-semibold text-gray-900">{{ number_format($projects['active']) }}</p>
                    <p class="mt-1 text-xs text-gray-500">Total: {{ number_format($projects['total']) }} · Completed: {{ number_format($projects['completed']) }} · Average progress: {{ $projects['avg_progress'] }}%</p>
                </article>

                <article class="bg-white border border-gray-200 rounded-xl p-5">
                    <p class="text-sm text-gray-500">Tasks</p>
                    <p class="mt-2 text-3xl font-semibold text-gray-900">{{ number_format($tasks['open']) }}</p>
                    <p class="mt-1 text-xs text-gray-500">Total: {{ number_format($tasks['total']) }} · Done: {{ number_format($tasks['done']) }} · Overdue: {{ number_format($tasks['overdue']) }}</p>
                </article>

                <article class="bg-white border border-gray-200 rounded-xl p-5">
                    <p class="text-sm text-gray-500">Completing tasks</p>
                    <p class="mt-2 text-3xl font-semibold text-gray-900">{{ $tasks['completion_rate'] }}%</p>
                    <div class="mt-2 h-2 rounded-full bg-gray-100">
                        <div class="h-2 rounded-full bg-emerald-500" style="width: {{ $tasks['completion_rate'] }}%;"></div>
                    </div>
                </article>

                <article class="bg-white border border-gray-200 rounded-xl p-5">
                    <p class="text-sm text-gray-500">Project budget</p>
                    <p class="mt-2 text-3xl font-semibold text-gray-900">${{ number_format((float) $projects['budget'], 0, '.', ' ') }}</p>
                    <p class="mt-1 text-xs text-gray-500">Mastered: ${{ number_format((float) $projects['spent'], 0, '.', ' ') }}</p>
                </article>
            </section>

            <section class="grid grid-cols-1 xl:grid-cols-2 gap-6">
                <article class="bg-white border border-gray-200 rounded-xl p-5 overflow-hidden">
                    <h3 class="font-semibold text-gray-900 mb-4">Dynamics by month</h3>

                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Month</th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">New deals</th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Successful transactions</th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">New projects</th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Completed projects</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 bg-white">
                            @foreach ($trend as $row)
                                <tr>
                                    <td class="px-3 py-2 text-sm text-gray-800">{{ $row['label'] }}</td>
                                    <td class="px-3 py-2 text-sm text-gray-700">{{ $row['new_deals'] }}</td>
                                    <td class="px-3 py-2 text-sm text-gray-700">{{ $row['won_deals'] }}</td>
                                    <td class="px-3 py-2 text-sm text-gray-700">{{ $row['new_projects'] }}</td>
                                    <td class="px-3 py-2 text-sm text-gray-700">{{ $row['completed_projects'] }}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </article>

                <article class="bg-white border border-gray-200 rounded-xl p-5 overflow-hidden">
                    <h3 class="font-semibold text-gray-900 mb-4">Employee workload</h3>

                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Employee</th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Transactions</th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Projects</th>
                                <th class="px-3 py-2 text-left text-xs font-medium text-gray-500 uppercase">Tasks</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 bg-white">
                            @forelse ($teamPerformance as $user)
                                <tr>
                                    <td class="px-3 py-2 text-sm text-gray-800">{{ $user->name }}</td>
                                    <td class="px-3 py-2 text-sm text-gray-700">{{ $user->open_deals_count }}</td>
                                    <td class="px-3 py-2 text-sm text-gray-700">{{ $user->active_projects_count }}</td>
                                    <td class="px-3 py-2 text-sm text-gray-700">{{ $user->open_tasks_count }} in work / {{ $user->done_tasks_count }} completed</td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="4" class="px-3 py-6 text-center text-sm text-gray-500">No command data available.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </article>
            </section>
        </div>
    </div>
</x-app-layout>
