@php
    $requestModel = $remoteAccessRequest;
    $snapshot = $connectionSnapshot ?? null;
    $counterpart = $counterpart ?? null;
    $browserSessionUrl = $browserSessionUrl ?? null;
    $copyText = trim((string) ($requestModel->response_message ?? ''));
@endphp

<div class="space-y-4">
    <section class="rounded-xl border border-slate-200 bg-white p-5 shadow-sm">
        <div class="flex flex-wrap items-start justify-between gap-3">
            <div>
                <h3 class="text-base font-semibold text-slate-900">{{ __('Remote access') }}</h3>
                <p class="mt-1 text-sm text-slate-500">
                    {{ __('Request status') }}:
                    <span class="font-medium text-slate-700">{{ __(ucfirst((string) $requestModel->status)) }}</span>
                </p>
            </div>

            @if ($counterpart)
                <div class="text-right text-sm text-slate-500">
                    <p class="font-medium text-slate-700">{{ $counterpart->name }}</p>
                    <p>{{ $counterpart->email }}</p>
                </div>
            @endif
        </div>

        @if ($requestModel->status === 'approved' && $snapshot)
            <div class="mt-5 grid gap-4 lg:grid-cols-2">
                <div class="rounded-xl border border-slate-200 bg-slate-50 p-4">
                    <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">{{ __('Remote access tool') }}</p>
                    <p class="mt-1 text-sm font-medium text-slate-900">{{ $snapshot['provider_label'] ?? __('Remote access') }}</p>
                </div>

                <div class="rounded-xl border border-slate-200 bg-slate-50 p-4">
                    <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">{{ __('Connection ID / host') }}</p>
                    <p class="mt-1 break-all text-sm font-medium text-slate-900">{{ $snapshot['address'] ?? '—' }}</p>
                </div>

                @if (!empty($snapshot['username']))
                    <div class="rounded-xl border border-slate-200 bg-slate-50 p-4">
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">{{ __('Username') }}</p>
                        <p class="mt-1 break-all text-sm font-medium text-slate-900">{{ $snapshot['username'] }}</p>
                    </div>
                @endif

                @if (!empty($snapshot['port']))
                    <div class="rounded-xl border border-slate-200 bg-slate-50 p-4">
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">{{ __('Port') }}</p>
                        <p class="mt-1 break-all text-sm font-medium text-slate-900">{{ $snapshot['port'] }}</p>
                    </div>
                @endif

                @if (!empty($snapshot['password']))
                    <div class="rounded-xl border border-slate-200 bg-slate-50 p-4">
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">{{ __('Password / code') }}</p>
                        <p class="mt-1 break-all text-sm font-medium text-slate-900">{{ $snapshot['password'] }}</p>
                    </div>
                @endif

                @if (!empty($snapshot['web_url']))
                    <div class="rounded-xl border border-slate-200 bg-slate-50 p-4">
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">{{ __('Browser URL') }}</p>
                        <p class="mt-1 break-all text-sm font-medium text-slate-900">{{ $snapshot['web_url'] }}</p>
                    </div>
                @endif

                @if (!empty($snapshot['notes']))
                    <div class="rounded-xl border border-slate-200 bg-slate-50 p-4">
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">{{ __('Comment') }}</p>
                        <p class="mt-1 whitespace-pre-wrap text-sm text-slate-700">{{ $snapshot['notes'] }}</p>
                    </div>
                @endif
            </div>

            <div class="mt-4 flex flex-wrap items-center gap-2">
                @if ($browserSessionUrl)
                    <a
                        href="{{ $browserSessionUrl }}"
                        target="_blank"
                        rel="noreferrer noopener"
                        class="inline-flex items-center rounded-md bg-emerald-600 px-4 py-2 text-sm font-medium text-white hover:bg-emerald-500"
                    >
                        {{ __('Open in browser') }}
                    </a>
                @endif

                @if (!empty($snapshot['launch_url']))
                    <a
                        href="{{ $snapshot['launch_url'] }}"
                        class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500"
                    >
                        {{ __('Open in app') }}
                    </a>
                @endif

                @if ($copyText !== '')
                    <button
                        type="button"
                        data-copy-text="{{ $copyText }}"
                        onclick="navigator.clipboard?.writeText(this.dataset.copyText || '')"
                        class="inline-flex items-center rounded-md border border-slate-300 bg-white px-4 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50"
                    >
                        {{ __('Copy connection details') }}
                    </button>
                @endif
            </div>
        @elseif ($requestModel->status === 'approved')
            <div class="mt-4 rounded-xl border border-amber-200 bg-amber-50 px-4 py-3 text-sm text-amber-700">
                {{ __('The request was approved, but no structured connection details were attached.') }}
            </div>
        @elseif ($requestModel->status === 'declined')
            <div class="mt-4 rounded-xl border border-rose-200 bg-rose-50 px-4 py-3 text-sm text-rose-700">
                {{ __('The remote access request was declined.') }}
            </div>
        @endif

        @if ($requestModel->response_message)
            <div class="mt-4 rounded-xl border border-slate-200 bg-slate-50 p-4">
                <p class="text-xs font-semibold uppercase tracking-wide text-slate-500">{{ __('Response') }}</p>
                <p class="mt-1 whitespace-pre-wrap text-sm text-slate-700">{{ $requestModel->response_message }}</p>
            </div>
        @endif
    </section>
</div>
