<section id="remote-access-requests" class="space-y-5">
    <header>
        <h3 class="text-lg font-semibold text-slate-900">{{ __('Remote access requests') }}</h3>
        <p class="mt-1 text-sm text-slate-500">{{ __('Approve or decline requests from colleagues who need temporary access to your workstation.') }}</p>
    </header>

    @if ($errors->has('response_message'))
        <div class="rounded-xl border border-rose-200 bg-rose-50 px-4 py-3 text-sm text-rose-700">
            {{ $errors->first('response_message') }}
        </div>
    @endif

    @if (empty($remoteAccessProfileConfigured ?? false))
        <div class="rounded-xl border border-amber-200 bg-amber-50 px-4 py-3 text-sm text-amber-700">
            {{ __('Your remote access details are not configured in the profile yet. To approve a request, fill them in above or enter them manually in the response field.') }}
        </div>
    @endif

    <div class="grid gap-5 xl:grid-cols-2">
        <div class="rounded-xl border border-slate-200 bg-slate-50/70 p-4">
            <div class="mb-3 flex items-center justify-between gap-2">
                <h4 class="text-sm font-semibold text-slate-900">{{ __('Incoming requests') }}</h4>
                <span class="rounded-full bg-white px-2.5 py-1 text-xs font-medium text-slate-500">{{ ($incomingRemoteAccessRequests ?? collect())->where('status', 'requested')->count() }}</span>
            </div>

            <div class="space-y-3">
                @forelse (($incomingRemoteAccessRequests ?? collect()) as $remoteAccessRequest)
                    @php
                        $requester = $remoteAccessRequest->requester;
                        $isPending = $remoteAccessRequest->status === 'requested';
                        $statusTone = match ($remoteAccessRequest->status) {
                            'approved' => 'border-emerald-200 bg-emerald-50 text-emerald-700',
                            'declined' => 'border-rose-200 bg-rose-50 text-rose-700',
                            default => 'border-amber-200 bg-amber-50 text-amber-700',
                        };
                    @endphp
                    <article class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                        <div class="flex items-start justify-between gap-3">
                            <div class="min-w-0">
                                <p class="truncate text-sm font-semibold text-slate-900">{{ $requester?->name ?: __('Unknown user') }}</p>
                                <p class="truncate text-xs text-slate-500">{{ $requester?->email ?: '—' }}</p>
                                <p class="mt-1 text-xs text-slate-400">{{ $remoteAccessRequest->requested_at?->diffForHumans() ?? '—' }}</p>
                            </div>
                            <span class="{{ $statusTone }} inline-flex items-center rounded-full border px-2.5 py-1 text-[11px] font-medium">
                                {{ __(ucfirst((string) $remoteAccessRequest->status)) }}
                            </span>
                        </div>

                        @if ($remoteAccessRequest->request_message)
                            <p class="mt-3 rounded-lg bg-slate-50 px-3 py-2 text-xs text-slate-600">{{ $remoteAccessRequest->request_message }}</p>
                        @endif

                        @if ($isPending)
                            <div class="mt-4 grid gap-3 md:grid-cols-2">
                                <form method="POST" action="{{ route('profile.remote-access-requests.update', $remoteAccessRequest) }}" class="space-y-2">
                                    @csrf
                                    @method('PATCH')
                                    <input type="hidden" name="status" value="approved">
                                    <textarea name="response_message" rows="2" class="w-full rounded-lg border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="{{ __('Connection details or comment (optional)') }}"></textarea>
                                    <button type="submit" class="inline-flex w-full items-center justify-center rounded-lg bg-emerald-600 px-3 py-2 text-sm font-medium text-white hover:bg-emerald-500">
                                        {{ __('Approve') }}
                                    </button>
                                </form>

                                <form method="POST" action="{{ route('profile.remote-access-requests.update', $remoteAccessRequest) }}" class="space-y-2">
                                    @csrf
                                    @method('PATCH')
                                    <input type="hidden" name="status" value="declined">
                                    <textarea name="response_message" rows="2" class="w-full rounded-lg border-slate-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="{{ __('Reason or comment (optional)') }}"></textarea>
                                    <button type="submit" class="inline-flex w-full items-center justify-center rounded-lg border border-rose-300 bg-white px-3 py-2 text-sm font-medium text-rose-600 hover:bg-rose-50">
                                        {{ __('Decline') }}
                                    </button>
                                </form>
                            </div>
                        @elseif ($remoteAccessRequest->response_message)
                            <p class="mt-3 rounded-lg bg-slate-50 px-3 py-2 text-xs text-slate-600">{{ $remoteAccessRequest->response_message }}</p>
                        @endif
                    </article>
                @empty
                    <div class="rounded-xl border border-dashed border-slate-300 bg-white px-4 py-8 text-center text-sm text-slate-500">
                        {{ __('There are no incoming remote access requests.') }}
                    </div>
                @endforelse
            </div>
        </div>

        <div class="rounded-xl border border-slate-200 bg-slate-50/70 p-4">
            <div class="mb-3 flex items-center justify-between gap-2">
                <h4 class="text-sm font-semibold text-slate-900">{{ __('Outgoing requests') }}</h4>
                <span class="rounded-full bg-white px-2.5 py-1 text-xs font-medium text-slate-500">{{ ($outgoingRemoteAccessRequests ?? collect())->count() }}</span>
            </div>

            <div class="space-y-3">
                @forelse (($outgoingRemoteAccessRequests ?? collect()) as $remoteAccessRequest)
                    @php
                        $recipient = $remoteAccessRequest->recipient;
                        $statusTone = match ($remoteAccessRequest->status) {
                            'approved' => 'border-emerald-200 bg-emerald-50 text-emerald-700',
                            'declined' => 'border-rose-200 bg-rose-50 text-rose-700',
                            default => 'border-amber-200 bg-amber-50 text-amber-700',
                        };
                    @endphp
                    <article class="rounded-xl border border-slate-200 bg-white p-4 shadow-sm">
                        <div class="flex items-start justify-between gap-3">
                            <div class="min-w-0">
                                <p class="truncate text-sm font-semibold text-slate-900">{{ $recipient?->name ?: __('Unknown user') }}</p>
                                <p class="truncate text-xs text-slate-500">{{ $recipient?->email ?: '—' }}</p>
                                <p class="mt-1 text-xs text-slate-400">{{ $remoteAccessRequest->requested_at?->diffForHumans() ?? '—' }}</p>
                            </div>
                            <span class="{{ $statusTone }} inline-flex items-center rounded-full border px-2.5 py-1 text-[11px] font-medium">
                                {{ __(ucfirst((string) $remoteAccessRequest->status)) }}
                            </span>
                        </div>

                        @if ($remoteAccessRequest->request_message)
                            <p class="mt-3 rounded-lg bg-slate-50 px-3 py-2 text-xs text-slate-600">{{ $remoteAccessRequest->request_message }}</p>
                        @endif

                        @if ($remoteAccessRequest->response_message)
                            <div class="mt-3 rounded-lg border border-slate-200 bg-slate-50 px-3 py-2">
                                <p class="text-[11px] font-medium uppercase tracking-wide text-slate-400">{{ __('Response') }}</p>
                                <p class="mt-1 text-xs text-slate-600">{{ $remoteAccessRequest->response_message }}</p>
                            </div>
                        @endif

                        @if ($remoteAccessRequest->status === 'approved')
                            <div class="mt-3">
                                <a
                                    href="{{ route('remote-access-requests.show', ['remoteAccessRequest' => $remoteAccessRequest, 'sidepanel' => 1]) }}"
                                    class="inline-flex items-center rounded-md bg-emerald-600 px-3 py-2 text-xs font-medium text-white hover:bg-emerald-500"
                                    onclick="if (window.crmSidepanel && typeof window.crmSidepanel.open === 'function') { event.preventDefault(); window.crmSidepanel.open(this.href, @js(__('Remote access')), { allowAny: true }); }"
                                >
                                    {{ __('Open remote session') }}
                                </a>
                            </div>
                        @endif
                    </article>
                @empty
                    <div class="rounded-xl border border-dashed border-slate-300 bg-white px-4 py-8 text-center text-sm text-slate-500">
                        {{ __('You have not requested remote access yet.') }}
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</section>
