@php
    $oldPermissions = old('permissions');
    $hasOldPermissions = is_array($oldPermissions);
@endphp

<section class="space-y-6">
    <header>
        <h2 class="text-lg font-medium text-gray-900 inline-flex items-center gap-2">
            <x-menu-icon name="settings" class="h-5 w-5 text-gray-500" />
            API integration keys
        </h2>

        <p class="mt-1 text-sm text-gray-600">
            Issue several keys and set rights by module separately: read, create, change, delete.
        </p>
    </header>

    @if (session('api_token_plain_text'))
        <div class="rounded-lg border border-amber-200 bg-amber-50 p-4">
            <p class="text-sm font-semibold text-amber-900">New API key (displayed once)</p>
            <code class="mt-2 block overflow-x-auto rounded-md bg-white px-3 py-2 text-xs text-amber-900">{{ session('api_token_plain_text') }}</code>
        </div>
    @endif

    <form method="POST" action="{{ route('profile.api-tokens.store') }}" class="space-y-4 rounded-lg border border-gray-200 p-4">
        @csrf

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
            <div>
                <label for="api-token-name" class="block text-sm font-medium text-gray-700">Key name</label>
                <input
                    id="api-token-name"
                    type="text"
                    name="name"
                    value="{{ old('name') }}"
                    class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                    placeholder="For example: Mobile iOS"
                    required
                >
                <x-input-error class="mt-2" :messages="$errors->get('name')" />
            </div>

            <div>
                <label for="api-token-expires" class="block text-sm font-medium text-gray-700">Validity period (optional)</label>
                <input
                    id="api-token-expires"
                    type="date"
                    name="expires_at"
                    value="{{ old('expires_at') }}"
                    class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                >
                <x-input-error class="mt-2" :messages="$errors->get('expires_at')" />
            </div>
        </div>

        <div class="overflow-hidden rounded-lg border border-gray-200">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Module</th>
                        @foreach ($apiTokenActions as $actionKey => $actionLabel)
                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">{{ $actionLabel }}</th>
                        @endforeach
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-100 bg-white">
                    @foreach ($apiTokenModules as $moduleKey => $moduleLabel)
                        <tr>
                            <td class="px-3 py-2 text-sm font-medium text-gray-800">{{ $moduleLabel }}</td>
                            @foreach ($apiTokenActions as $actionKey => $actionLabel)
                                @php
                                    $isChecked = $hasOldPermissions
                                        ? (bool) data_get($oldPermissions, $moduleKey.'.'.$actionKey)
                                        : false;
                                @endphp
                                <td class="px-3 py-2">
                                    <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                        <input
                                            type="checkbox"
                                            name="permissions[{{ $moduleKey }}][{{ $actionKey }}]"
                                            value="1"
                                            class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                            @checked($isChecked)
                                        >
                                        <span class="sr-only">{{ $moduleLabel }} {{ $actionLabel }}</span>
                                    </label>
                                </td>
                            @endforeach
                        </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <x-input-error class="mt-2" :messages="$errors->get('permissions')" />

        <div class="flex items-center gap-3">
            <x-primary-button>Release API key</x-primary-button>
        </div>
    </form>

    <div class="space-y-3">
        <h3 class="text-sm font-semibold text-gray-900">Issued keys</h3>

        @if ($apiTokens->isEmpty())
            <p class="text-sm text-gray-500">No keys yet.</p>
        @else
            <div class="overflow-hidden rounded-lg border border-gray-200">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Key</th>
                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Rights</th>
                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Usage</th>
                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Term</th>
                            <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-gray-500">Action</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 bg-white">
                        @foreach ($apiTokens as $token)
                            <tr>
                                <td class="px-3 py-3 align-top">
                                    <p class="text-sm font-medium text-gray-900">{{ $token['name'] }}</p>
                                    <p class="text-xs text-gray-500">ID: {{ $token['id'] }} · created {{ $token['created_at']?->format('d.m.Y H:i') }}</p>
                                </td>
                                <td class="px-3 py-3 align-top">
                                    @if ($token['ability_labels'] === [])
                                        <span class="text-xs text-gray-500">No rights</span>
                                    @else
                                        <div class="flex flex-wrap gap-1">
                                            @foreach ($token['ability_labels'] as $label)
                                                <span class="rounded-md bg-gray-100 px-2 py-1 text-xs text-gray-700">{{ $label }}</span>
                                            @endforeach
                                        </div>
                                    @endif
                                </td>
                                <td class="px-3 py-3 align-top text-xs text-gray-700">
                                    {{ $token['last_used_at'] ? $token['last_used_at']->format('d.m.Y H:i') : 'Not used' }}
                                </td>
                                <td class="px-3 py-3 align-top text-xs text-gray-700">
                                    {{ $token['expires_at'] ? $token['expires_at']->format('d.m.Y H:i') : 'No deadline' }}
                                </td>
                                <td class="px-3 py-3 align-top">
                                    <form method="POST" action="{{ route('profile.api-tokens.destroy', $token['id']) }}" onsubmit="return confirm('Revoke the key?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="text-sm text-red-600 hover:text-red-500">Revoke</button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        @endif
    </div>

    @include('profile.partials.api-documentation')
</section>
