<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">{{ __('Mail Service') }}</h2>
                <p class="text-sm text-gray-500">{{ __('Configure mailbox integration and issue addresses to users.') }}</p>
            </div>
            <div class="flex items-center gap-2">
                @include('partials.section-access-controls', [
                    'sectionAccessEntity' => 'mail',
                    'sectionAccessTitle' => __('Mail Service'),
                    'canManageSectionAccess' => $canManageSectionAccess ?? false,
                    'sectionAccessUsers' => $sectionAccessUsers ?? collect(),
                ])
            </div>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-4">
            <section class="bg-white border border-gray-200 rounded-xl p-4 space-y-4">
                <div class="flex flex-wrap items-start justify-between gap-3">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">{{ __('Mail service settings') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Set provider connection and automatic mailbox provisioning rules.') }}</p>
                    </div>
                    <span class="inline-flex items-center rounded-full px-2.5 py-1 text-xs font-medium {{ ($settings->is_active ?? false) ? 'bg-emerald-100 text-emerald-700' : 'bg-slate-100 text-slate-600' }}">
                        {{ ($settings->is_active ?? false) ? __('Active') : __('Disabled') }}
                    </span>
                </div>

                @if ($canManageSettings)
                    <form method="POST" action="{{ route('mail.settings.update') }}" class="grid grid-cols-1 gap-4">
                        @csrf
                        @method('PATCH')

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Provider') }}</label>
                                <input name="provider" type="text" value="{{ old('provider', $settings->provider) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="Mailcow / Google Workspace / Exchange">
                                <x-input-error class="mt-1" :messages="$errors->get('provider')" />
                            </div>

                            <div class="flex items-end">
                                <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                    <input type="checkbox" name="is_active" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('is_active', $settings->is_active))>
                                    {{ __('Active integration') }}
                                </label>
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Mail domain') }}</label>
                                <input name="domain" type="text" value="{{ old('domain', $settings->domain) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="crm.local">
                                <x-input-error class="mt-1" :messages="$errors->get('domain')" />
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Account ID') }}</label>
                                <input name="account_id" type="text" value="{{ old('account_id', $settings->account_id) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('account_id')" />
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('API base URL') }}</label>
                                <input name="api_base_url" type="text" value="{{ old('api_base_url', $settings->api_base_url) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="https://mail-api.example.com">
                                <x-input-error class="mt-1" :messages="$errors->get('api_base_url')" />
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Webhook secret') }}</label>
                                <input name="webhook_secret" type="text" value="{{ old('webhook_secret', $settings->webhook_secret) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('webhook_secret')" />
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('API key') }}</label>
                                <input name="api_key" type="text" value="{{ old('api_key', $settings->api_key) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('api_key')" />
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('API secret') }}</label>
                                <input name="api_secret" type="text" value="{{ old('api_secret', $settings->api_secret) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('api_secret')" />
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-4 md:grid-cols-2">
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Default mailbox status') }}</label>
                                <select name="default_status" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach ($statusOptions as $statusKey => $statusLabel)
                                        <option value="{{ $statusKey }}" @selected(old('default_status', $settings->default_status ?? 'active') === $statusKey)>{{ $statusLabel }}</option>
                                    @endforeach
                                </select>
                                <x-input-error class="mt-1" :messages="$errors->get('default_status')" />
                            </div>
                            <div>
                                <label class="block text-sm font-medium text-gray-700">{{ __('Default quota (MB)') }}</label>
                                <input name="default_quota_mb" type="number" min="1" max="102400" value="{{ old('default_quota_mb', $settings->default_quota_mb ?? 2048) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('default_quota_mb')" />
                            </div>
                        </div>

                        <div class="grid grid-cols-1 gap-2 md:grid-cols-2">
                            <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                <input type="checkbox" name="auto_provision_on_registration" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('auto_provision_on_registration', $settings->auto_provision_on_registration ?? true))>
                                {{ __('Auto-create mailbox on self registration') }}
                            </label>
                            <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                <input type="checkbox" name="auto_provision_on_user_create" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('auto_provision_on_user_create', $settings->auto_provision_on_user_create ?? true))>
                                {{ __('Auto-create mailbox when admin creates user') }}
                            </label>
                        </div>

                        <div class="flex justify-end">
                            <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">
                                {{ __('Save settings') }}
                            </button>
                        </div>
                    </form>
                @else
                    <p class="text-sm text-gray-500">{{ __('You do not have rights to edit mail settings.') }}</p>
                @endif
            </section>

            <section class="bg-white border border-gray-200 rounded-xl p-4 space-y-4">
                <div class="flex flex-wrap items-center justify-between gap-3">
                    <div>
                        <h3 class="text-lg font-semibold text-gray-900">{{ __('Mailboxes') }}</h3>
                        <p class="text-sm text-gray-500">{{ __('Issue, manage, and filter user mailboxes.') }}</p>
                    </div>
                    <div class="text-xs text-gray-500">{{ __('Total:') }} {{ $mailboxes->total() }}</div>
                </div>

                <form method="GET" action="{{ route('mail.index') }}" class="grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-6">
                    <div class="xl:col-span-2">
                        <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Search') }}</label>
                        <input type="text" name="q" value="{{ $search }}" placeholder="{{ __('Address, alias or forwarding') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div>
                        <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Status') }}</label>
                        <select name="status" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">{{ __('All') }}</option>
                            @foreach ($statusOptions as $value => $label)
                                <option value="{{ $value }}" @selected($status === $value)>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Domain') }}</label>
                        <input type="text" name="domain" value="{{ $domain }}" placeholder="crm.local" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div>
                        <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('User') }}</label>
                        <x-user-search-select
                            id="mail-user-filter"
                            name="user_id"
                            :users="$userOptions"
                            :selected="$selectedUserId"
                            :placeholder="__('All users')"
                            :empty-label="__('All')"
                        />
                    </div>

                    <div class="flex items-end gap-2">
                        <button type="submit" class="inline-flex items-center rounded-md bg-gray-800 px-4 py-2 text-sm font-medium text-white hover:bg-gray-700">
                            {{ __('Find') }}
                        </button>
                        <a href="{{ route('mail.index') }}" class="inline-flex items-center rounded-md border border-gray-300 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50">
                            {{ __('Reset') }}
                        </a>
                    </div>

                    <div>
                        <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('From date') }}</label>
                        <input type="date" name="date_from" value="{{ $dateFrom }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>

                    <div>
                        <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('To date') }}</label>
                        <input type="date" name="date_to" value="{{ $dateTo }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                    </div>
                </form>

                @if ($canCreateMailbox)
                    <details class="rounded-lg border border-gray-200 bg-gray-50 p-3">
                        <summary class="cursor-pointer text-sm font-medium text-gray-700">{{ __('Issue mailbox') }}</summary>
                        <form method="POST" action="{{ route('mail.mailboxes.store') }}" class="mt-3 grid grid-cols-1 gap-3 md:grid-cols-2 xl:grid-cols-6">
                            @csrf

                            <div>
                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('User') }}</label>
                                <x-user-search-select
                                    id="mail-user-create"
                                    name="user_id"
                                    :users="$userOptions"
                                    :selected="old('user_id')"
                                    :placeholder="__('Select user')"
                                    :empty-label="__('Not selected')"
                                />
                                <x-input-error class="mt-1" :messages="$errors->get('user_id')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Local part') }}</label>
                                <input name="local_part" type="text" value="{{ old('local_part') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="john.doe">
                                <x-input-error class="mt-1" :messages="$errors->get('local_part')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Domain') }}</label>
                                <input name="domain" type="text" value="{{ old('domain', $settings->domain) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('domain')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Status') }}</label>
                                <select name="status" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                    @foreach ($statusOptions as $statusKey => $statusLabel)
                                        <option value="{{ $statusKey }}" @selected(old('status', $settings->default_status ?? 'active') === $statusKey)>{{ $statusLabel }}</option>
                                    @endforeach
                                </select>
                                <x-input-error class="mt-1" :messages="$errors->get('status')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Quota (MB)') }}</label>
                                <input name="quota_mb" type="number" min="1" max="102400" value="{{ old('quota_mb', $settings->default_quota_mb ?? 2048) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('quota_mb')" />
                            </div>

                            <div>
                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Used (MB)') }}</label>
                                <input name="used_mb" type="number" min="0" value="{{ old('used_mb', 0) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('used_mb')" />
                            </div>

                            <div class="md:col-span-2 xl:col-span-3">
                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Forwarding address') }}</label>
                                <input name="forward_to" type="email" value="{{ old('forward_to') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500" placeholder="alias@example.com">
                                <x-input-error class="mt-1" :messages="$errors->get('forward_to')" />
                            </div>

                            <div class="md:col-span-2 xl:col-span-2">
                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Mailbox password') }}</label>
                                <input name="password" type="text" value="{{ old('password') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                <x-input-error class="mt-1" :messages="$errors->get('password')" />
                            </div>

                            <div class="flex items-end">
                                <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                                    <input type="checkbox" name="is_primary" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked(old('is_primary', true))>
                                    {{ __('Primary mailbox') }}
                                </label>
                            </div>

                            <div class="md:col-span-2 xl:col-span-6 flex justify-end">
                                <button type="submit" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">
                                    {{ __('Create mailbox') }}
                                </button>
                            </div>
                        </form>
                    </details>
                @endif

                <div class="overflow-hidden rounded-lg border border-gray-200">
                    <table class="min-w-full divide-y divide-gray-200">
                        <thead class="bg-gray-50">
                            <tr>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Address') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('User') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Status') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Primary') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Quota') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Forwarding') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Provisioned') }}</th>
                                <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">{{ __('Actions') }}</th>
                            </tr>
                        </thead>
                        <tbody class="divide-y divide-gray-100 bg-white">
                            @forelse ($mailboxes as $mailbox)
                                <tr class="hover:bg-gray-50">
                                    <td class="px-4 py-3 text-sm text-gray-800">
                                        <div class="font-medium">{{ $mailbox->address }}</div>
                                        <div class="text-xs text-gray-500">{{ $mailbox->local_part }} / {{ $mailbox->domain }}</div>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-gray-700">
                                        <div>{{ $mailbox->user?->name ?? '—' }}</div>
                                        <div class="text-xs text-gray-500">{{ $mailbox->user?->email ?? '—' }}</div>
                                    </td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $statusOptions[$mailbox->status] ?? ucfirst((string) $mailbox->status) }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $mailbox->is_primary ? __('Yes') : __('No') }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ (int) $mailbox->used_mb }} / {{ (int) $mailbox->quota_mb }} MB</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $mailbox->forward_to ?: '—' }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">{{ $mailbox->provisioned_at?->format('d.m.Y H:i') ?? '—' }}</td>
                                    <td class="px-4 py-3 text-sm text-gray-700">
                                        <div class="flex items-center gap-2">
                                            @if ($canUpdateMailbox)
                                                <details>
                                                    <summary class="cursor-pointer text-sm text-indigo-600">{{ __('Edit') }}</summary>
                                                    <form method="POST" action="{{ route('mail.mailboxes.update', $mailbox) }}" class="mt-2 grid grid-cols-1 gap-2 rounded-md border border-gray-200 bg-white p-3 w-80">
                                                        @csrf
                                                        @method('PATCH')
                                                        <div>
                                                            <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('User') }}</label>
                                                            <x-user-search-select
                                                                id="mailbox-user-{{ $mailbox->id }}"
                                                                name="user_id"
                                                                :users="$userOptions"
                                                                :selected="$mailbox->user_id"
                                                                :placeholder="__('Select user')"
                                                                :empty-label="__('Not selected')"
                                                            />
                                                        </div>
                                                        <div class="grid grid-cols-2 gap-2">
                                                            <div>
                                                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Local part') }}</label>
                                                                <input name="local_part" type="text" value="{{ $mailbox->local_part }}" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                                            </div>
                                                            <div>
                                                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Domain') }}</label>
                                                                <input name="domain" type="text" value="{{ $mailbox->domain }}" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                                            </div>
                                                        </div>
                                                        <div class="grid grid-cols-2 gap-2">
                                                            <div>
                                                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Status') }}</label>
                                                                <select name="status" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                                                    @foreach ($statusOptions as $statusKey => $statusLabel)
                                                                        <option value="{{ $statusKey }}" @selected($mailbox->status === $statusKey)>{{ $statusLabel }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            <div>
                                                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Forwarding address') }}</label>
                                                                <input name="forward_to" type="email" value="{{ $mailbox->forward_to }}" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                                            </div>
                                                        </div>
                                                        <div class="grid grid-cols-2 gap-2">
                                                            <div>
                                                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Quota (MB)') }}</label>
                                                                <input name="quota_mb" type="number" min="1" max="102400" value="{{ (int) $mailbox->quota_mb }}" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                                            </div>
                                                            <div>
                                                                <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Used (MB)') }}</label>
                                                                <input name="used_mb" type="number" min="0" value="{{ (int) $mailbox->used_mb }}" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                                            </div>
                                                        </div>
                                                        <div>
                                                            <label class="block text-xs font-medium text-gray-500 uppercase">{{ __('Mailbox password') }}</label>
                                                            <input name="password" type="text" value="{{ $mailbox->password }}" class="mt-1 w-full rounded-md border-gray-300 text-sm shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                                                        </div>
                                                        <label class="inline-flex items-center gap-2 text-xs text-gray-700">
                                                            <input type="checkbox" name="is_primary" value="1" class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500" @checked($mailbox->is_primary)>
                                                            {{ __('Primary mailbox') }}
                                                        </label>
                                                        <div class="flex justify-end">
                                                            <button type="submit" class="inline-flex items-center rounded-md bg-gray-800 px-3 py-1.5 text-xs font-medium text-white hover:bg-gray-700">
                                                                {{ __('Save') }}
                                                            </button>
                                                        </div>
                                                    </form>
                                                </details>
                                            @endif

                                            @if ($canDeleteMailbox)
                                                <form method="POST" action="{{ route('mail.mailboxes.destroy', $mailbox) }}" onsubmit="return confirm('{{ __('Delete mailbox?') }}')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="text-sm text-red-600 hover:text-red-500">{{ __('Delete') }}</button>
                                                </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="px-4 py-8 text-center text-sm text-gray-500">{{ __('No mailboxes found.') }}</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

                <div>
                    {{ $mailboxes->links() }}
                </div>
            </section>
        </div>
    </div>
</x-app-layout>

