<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-3">
            <div>
                <h2 class="text-xl font-semibold leading-tight text-gray-800">{{ __('Preview') }}: {{ $disk->name }}</h2>
                <p class="text-xs text-gray-500">{{ $disk->original_name }} · {{ strtoupper((string) ($disk->extension ?: 'file')) }}</p>
            </div>

            <div class="flex items-center gap-2">
                <a
                    href="{{ route('disks.index') }}"
                    class="inline-flex items-center rounded-md border border-slate-300 px-3 py-1.5 text-sm font-medium text-slate-700 transition hover:border-slate-400 hover:text-slate-900"
                >
                    {{ __('Back to disk') }}
                </a>
                <a
                    href="{{ route('disks.download', $disk) }}"
                    class="inline-flex items-center rounded-md border border-sky-200 bg-sky-50 px-3 py-1.5 text-sm font-medium text-sky-700 transition hover:border-sky-300 hover:bg-sky-100"
                >
                    {{ __('Download') }}
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="w-full px-6">
            <section class="rounded-xl border border-slate-200 bg-white shadow-sm">
                <header class="flex items-center justify-between gap-2 border-b border-slate-200 px-4 py-3">
                    <h3 class="text-sm font-semibold text-slate-800">{{ __($preview['title'] ?? 'Preview') }}</h3>
                    <span class="text-xs text-slate-500">{{ $disk->mime_type ?: 'application/octet-stream' }}</span>
                </header>

                @if (($preview['kind'] ?? '') === 'image')
                    <div class="flex min-h-[36rem] items-center justify-center rounded-b-xl bg-slate-950/95 p-6">
                        <img
                            src="{{ route('disks.inline', $disk) }}"
                            alt="{{ $disk->name }}"
                            class="max-h-[calc(100vh-16rem)] w-auto max-w-full rounded-lg object-contain shadow-2xl"
                        >
                    </div>
                @elseif (($preview['kind'] ?? '') === 'pdf')
                    <div class="h-[calc(100vh-14rem)] min-h-[36rem]">
                        <iframe
                            src="{{ route('disks.inline', $disk) }}"
                            class="h-full w-full rounded-b-xl"
                            title="{{ __('PDF preview') }}"
                        ></iframe>
                    </div>
                @elseif (($preview['kind'] ?? '') === 'word')
                    <div class="rounded-b-xl max-h-[calc(100vh-14rem)] overflow-hidden bg-slate-50 p-3">
                        <div
                            data-disk-word-preview
                            data-file-url="{{ route('disks.word-source', $disk) }}"
                            data-file-name="{{ $disk->original_name }}"
                            data-extension="{{ strtolower((string) ($disk->extension ?? '')) }}"
                            class="disk-word-preview flex h-[calc(100vh-18rem)] min-h-[28rem] flex-col overflow-hidden rounded-lg border border-slate-200 bg-slate-100"
                        >
                            <div class="border-b border-slate-200 bg-slate-50 px-3 py-2">
                                <p class="text-[11px] text-slate-500">{{ __('Word document preview') }}</p>
                            </div>

                            <div data-disk-word-status class="px-4 py-3 text-sm text-slate-500">
                                {{ __('Loading document...') }}
                            </div>

                            <div data-disk-word-canvas class="min-h-0 flex-1 overflow-auto px-3 py-4"></div>
                        </div>
                    </div>
                @elseif (($preview['kind'] ?? '') === 'excel')
                    <div class="rounded-b-xl max-h-[calc(100vh-14rem)] overflow-hidden bg-slate-50 p-3">
                        <div
                            data-disk-spreadsheet-preview
                            data-file-url="{{ route('disks.spreadsheet-source', $disk) }}"
                            data-file-name="{{ $disk->original_name }}"
                            data-extension="{{ strtolower((string) ($disk->extension ?? '')) }}"
                            class="disk-spreadsheet-preview flex h-[calc(100vh-18rem)] min-h-[28rem] flex-col overflow-hidden rounded-lg border border-slate-200 bg-white"
                        >
                            <div class="border-b border-slate-200 bg-slate-50 px-3 py-2">
                                <div data-disk-spreadsheet-tabs class="flex flex-wrap items-center gap-2"></div>
                                <p data-disk-spreadsheet-meta class="mt-1 text-[11px] text-slate-500"></p>
                            </div>

                            <div data-disk-spreadsheet-status class="px-4 py-3 text-sm text-slate-500">
                                {{ __('Loading table...') }}
                            </div>

                            <div data-disk-spreadsheet-grid class="min-h-0 flex-1"></div>
                        </div>
                    </div>
                @else
                    <div class="rounded-b-xl px-4 py-6">
                        <p class="text-sm text-slate-600">{{ __((string) ($preview['message'] ?? 'Preview is unavailable for this file type.')) }}</p>
                        <p class="mt-2 text-xs text-slate-500">{{ __('Built-in preview supports images, PDF, DOC, DOCX, XLSX, XLS and CSV.') }}</p>
                    </div>
                @endif
            </section>
        </div>
    </div>
</x-app-layout>
