@php
    $dealStatusLabels = [
        'open' => __('Open'),
        'won' => __('Won'),
        'lost' => __('Lost'),
    ];

    $dealPriorityLabels = [
        'low' => __('Low'),
        'medium' => __('Medium'),
        'high' => __('High'),
    ];

    $taskStatusLabels = [
        'todo' => __('To do'),
        'in_progress' => __('In progress'),
        'review' => __('Review'),
        'done' => __('Done'),
    ];
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">{{ $deal->title }}</h2>
                <p class="text-sm text-gray-500">{{ $deal->pipeline?->name }} · {{ $deal->stage?->name }}</p>
            </div>
            <a href="{{ route('deals.edit', $deal) }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">Edit</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-6">
            <section class="grid grid-cols-1 lg:grid-cols-3 gap-6">
                <div class="bg-white rounded-xl border border-gray-200 p-5 lg:col-span-2">
                    <h3 class="font-semibold text-gray-900">Transaction details</h3>
                    <dl class="mt-4 grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                        <div>
                            <dt class="text-gray-500">Sum</dt>
                            <dd class="text-gray-900">${{ number_format((float) $deal->amount, 0, '.', ' ') }} {{ $deal->currency }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Status</dt>
                            <dd class="text-gray-900">{{ $dealStatusLabels[$deal->status] ?? $deal->status }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Priority</dt>
                            <dd class="text-gray-900">{{ $dealPriorityLabels[$deal->priority] ?? $deal->priority }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Closing plan</dt>
                            <dd class="text-gray-900">{{ $deal->expected_close_at?->format('d.m.Y') ?: '—' }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Company</dt>
                            <dd class="text-gray-900">
                                @if ($deal->company)
                                    <a href="{{ route('companies.show', $deal->company) }}" class="text-indigo-600 hover:text-indigo-500">{{ $deal->company->name }}</a>
                                @else
                                    —
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Contact</dt>
                            <dd class="text-gray-900">
                                @if ($deal->contact)
                                    <a href="{{ route('contacts.show', $deal->contact) }}" class="text-indigo-600 hover:text-indigo-500">{{ $deal->contact->full_name ?: $deal->contact->first_name }}</a>
                                @else
                                    —
                                @endif
                            </dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Responsible</dt>
                            <dd class="text-gray-900">{{ $deal->owner?->name ?: '—' }}</dd>
                        </div>
                        <div>
                            <dt class="text-gray-500">Last activity</dt>
                            <dd class="text-gray-900">{{ $deal->last_activity_at?->format('d.m.Y H:i') ?: '—' }}</dd>
                        </div>
                    </dl>

                    @if ($deal->lost_reason)
                        <div class="mt-4 rounded-lg border border-red-200 bg-red-50 p-3 text-sm text-red-800">
                            <p class="font-medium">Reason for loss</p>
                            <p class="mt-1">{{ $deal->lost_reason }}</p>
                        </div>
                    @endif

                    <div class="mt-4 text-sm">
                        <p class="text-gray-500">Description</p>
                        <p class="mt-1 whitespace-pre-line text-gray-900">{{ $deal->description ?: 'No description' }}</p>
                    </div>
                </div>

                <div class="bg-white rounded-xl border border-gray-200 p-5">
                    <h3 class="font-semibold text-gray-900">Quick Actions</h3>
                    <div class="mt-3 space-y-2 text-sm">
                        <a href="{{ route('tasks.create', ['deal_id' => $deal->id, 'company_id' => $deal->company_id, 'contact_id' => $deal->contact_id]) }}" class="block rounded-md border border-gray-200 px-3 py-2 hover:bg-gray-50">Create a task</a>
                        <a href="{{ route('activities.create', ['deal_id' => $deal->id, 'company_id' => $deal->company_id, 'contact_id' => $deal->contact_id]) }}" class="block rounded-md border border-gray-200 px-3 py-2 hover:bg-gray-50">Add activity</a>
                    </div>

                    <form method="POST" action="{{ route('deals.update-stage', $deal) }}" class="mt-5">
                        @csrf
                        @method('PATCH')
                        <label for="stage_id" class="block text-sm font-medium text-gray-700">Change stage</label>
                        <select id="stage_id" name="stage_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            @foreach ($deal->pipeline->stages as $stage)
                                <option value="{{ $stage->id }}" @selected($deal->stage_id === $stage->id)>{{ $stage->name }}</option>
                            @endforeach
                        </select>
                        <button type="submit" class="mt-3 inline-flex items-center rounded-md bg-gray-800 px-4 py-2 text-sm font-medium text-white hover:bg-gray-700">Update stage</button>
                    </form>
                </div>
            </section>

            <section class="grid grid-cols-1 xl:grid-cols-2 gap-6">
                <div class="bg-white rounded-xl border border-gray-200 p-5">
                    <h3 class="font-semibold text-gray-900">Tasks ({{ $deal->tasks->count() }})</h3>
                    <div class="mt-3 space-y-2">
                        @forelse ($deal->tasks as $task)
                            <a href="{{ route('tasks.show', $task) }}" class="block rounded-md border border-gray-100 px-3 py-2 hover:bg-gray-50">
                                <p class="text-sm font-medium text-gray-900">{{ $task->title }}</p>
                                <p class="text-xs text-gray-500">{{ $taskStatusLabels[$task->status] ?? $task->status }} · {{ $task->assignee?->name ?? '—' }}</p>
                            </a>
                        @empty
                            <p class="text-sm text-gray-500">There are no tasks yet.</p>
                        @endforelse
                    </div>
                </div>

                <div class="bg-white rounded-xl border border-gray-200 p-5">
                    <h3 class="font-semibold text-gray-900">Activities ({{ $deal->activities->count() }})</h3>
                    <div class="mt-3 space-y-2">
                        @forelse ($deal->activities as $activity)
                            <a href="{{ route('activities.show', $activity) }}" class="block rounded-md border border-gray-100 px-3 py-2 hover:bg-gray-50">
                                <p class="text-sm font-medium text-gray-900">{{ $activity->subject }}</p>
                                <p class="text-xs text-gray-500">{{ strtoupper($activity->type) }} · {{ $activity->occurred_at?->format('d.m H:i') }}</p>
                            </a>
                        @empty
                            <p class="text-sm text-gray-500">No activity yet.</p>
                        @endforelse
                    </div>
                </div>
            </section>
        </div>
    </div>
</x-app-layout>
