@props([
    'name' => 'fa-solid fa-link',
    'mode' => 'svg',
])

@php
    $iconClass = \App\Support\MenuManager::iconFaClass((string) $name);
    $renderMode = in_array((string) $mode, ['svg', 'font'], true) ? (string) $mode : 'svg';
    $styleMap = [
        'fa-solid' => 'solid',
        'fas' => 'solid',
        'fa-regular' => 'regular',
        'far' => 'regular',
        'fa-brands' => 'brands',
        'fab' => 'brands',
    ];
    $iconTokens = preg_split('/\s+/', trim($iconClass)) ?: [];
    $styleToken = null;
    $iconToken = null;

    foreach ($iconTokens as $token) {
        if ($styleToken === null && array_key_exists($token, $styleMap)) {
            $styleToken = $token;
        }

        if (
            $iconToken === null
            && str_starts_with($token, 'fa-')
            && ! array_key_exists($token, $styleMap)
            && $token !== 'fa'
            && $token !== 'fa-classic'
        ) {
            $iconToken = $token;
        }
    }

    $svgMarkup = null;
    if ($renderMode === 'svg' && $styleToken !== null && $iconToken !== null) {
        $iconName = substr($iconToken, 3);
        if ($iconName !== '' && preg_match('/^[A-Za-z0-9-]+$/', $iconName) === 1) {
            $svgPath = base_path(sprintf(
                'node_modules/@fortawesome/fontawesome-free/svgs/%s/%s.svg',
                $styleMap[$styleToken],
                strtolower($iconName)
            ));

            if (is_file($svgPath)) {
                static $svgCache = [];
                $cacheKey = $styleMap[$styleToken].'/'.strtolower($iconName);

                if (! array_key_exists($cacheKey, $svgCache)) {
                    $svgCache[$cacheKey] = file_get_contents($svgPath) ?: '';
                }

                $rawSvg = $svgCache[$cacheKey];
                if ($rawSvg !== '') {
                    $svgMarkup = preg_replace(
                        '/<svg\b/',
                        '<svg class="h-full w-full" aria-hidden="true" focusable="false"',
                        $rawSvg,
                        1
                    );
                }
            }
        }
    }
@endphp

<span {{ $attributes->merge(['class' => 'inline-flex items-center justify-center']) }}>
    @if ($svgMarkup)
        {!! $svgMarkup !!}
    @else
        <i class="{{ $iconClass }} text-base leading-none"></i>
    @endif
</span>
