@php
    $filters = is_array($filters ?? null) ? $filters : [];
    $selectedAssigneeId = (int) ($filters['assignee_id'] ?? 0);
    $selectedProjectId = (int) ($filters['project_id'] ?? 0);
    $selectedStatus = (string) ($filters['status'] ?? '');
    $selectedPriority = (string) ($filters['priority'] ?? '');
    $search = (string) ($filters['q'] ?? '');
    $mine = (bool) ($filters['mine'] ?? false);

    $viewOptions = [
        'dayGridMonth' => 'Month',
        'timeGridWeek' => 'Week',
        'timeGridDay' => 'Day',
        'listWeek' => 'List',
    ];
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex flex-wrap items-center justify-between gap-3">
            <div>
                <h2 class="font-semibold text-xl text-gray-800 leading-tight">Task calendar</h2>
                <p class="text-sm text-gray-500">Tasks, activities and deal events in month/week/day/list formats</p>
            </div>
            <a href="{{ route('tasks.create') }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">
                New task
            </a>
        </div>
    </x-slot>

    <div class="pb-12" data-sidepanel-scope>
        <div class="w-full px-6 space-y-4">
            <section class="rounded-xl border border-gray-200 bg-white p-4">
                <form id="calendar-filters" method="GET" action="{{ route('calendar.index') }}" class="grid grid-cols-1 gap-3 md:grid-cols-3 xl:grid-cols-6">
                    <div class="xl:col-span-2">
                        <label for="calendar-q" class="block text-xs font-medium uppercase text-gray-500">Search</label>
                        <input
                            id="calendar-q"
                            name="q"
                            type="text"
                            value="{{ $search }}"
                            placeholder="Title, description, project, performer"
                            class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        >
                    </div>

                    <div>
                        <label for="calendar-assignee-id" class="block text-xs font-medium uppercase text-gray-500">Executor</label>
                        <x-user-search-select
                            id="calendar-assignee-id"
                            name="assignee_id"
                            :users="$users"
                            :selected="$selectedAssigneeId"
                            placeholder="All users"
                            empty-label="All"
                        />
                    </div>

                    <div>
                        <label for="calendar-project-id" class="block text-xs font-medium uppercase text-gray-500">Project</label>
                        <select
                            id="calendar-project-id"
                            name="project_id"
                            class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        >
                            <option value="">All</option>
                            @foreach ($projects as $project)
                                <option value="{{ $project->id }}" @selected($selectedProjectId === (int) $project->id)>{{ $project->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label for="calendar-status" class="block text-xs font-medium uppercase text-gray-500">Status</label>
                        <select
                            id="calendar-status"
                            name="status"
                            class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        >
                            <option value="">All</option>
                            @foreach ($statusLabels as $status => $label)
                                <option value="{{ $status }}" @selected($selectedStatus === (string) $status)>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label for="calendar-priority" class="block text-xs font-medium uppercase text-gray-500">Priority</label>
                        <select
                            id="calendar-priority"
                            name="priority"
                            class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500"
                        >
                            <option value="">All</option>
                            @foreach ($priorityLabels as $priority => $label)
                                <option value="{{ $priority }}" @selected($selectedPriority === (string) $priority)>{{ $label }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="flex items-end">
                        <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                            <input
                                id="calendar-mine"
                                type="checkbox"
                                name="mine"
                                value="1"
                                @checked($mine)
                                class="rounded border-gray-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                            >
                            Only mine
                        </label>
                    </div>

                    <div class="flex items-end gap-2">
                        <button type="submit" class="inline-flex items-center rounded-md bg-gray-800 px-4 py-2 text-sm font-medium text-white hover:bg-gray-700">
                            Apply
                        </button>
                        <a href="{{ route('calendar.index') }}" class="inline-flex items-center rounded-md border border-gray-300 px-4 py-2 text-sm font-medium text-gray-700 hover:bg-gray-50">
                            Reset
                        </a>
                    </div>
                </form>
            </section>

            <section class="rounded-xl border border-gray-200 bg-white p-4">
                <div class="mb-4 flex flex-wrap items-center justify-between gap-3">
                    <div class="flex items-center gap-2">
                        <button type="button" class="inline-flex h-9 items-center rounded-md border border-gray-300 px-3 text-sm text-gray-700 hover:bg-gray-50" data-calendar-action="prev">
                            ←
                        </button>
                        <button type="button" class="inline-flex h-9 items-center rounded-md border border-gray-300 px-3 text-sm text-gray-700 hover:bg-gray-50" data-calendar-action="today">
                            Today
                        </button>
                        <button type="button" class="inline-flex h-9 items-center rounded-md border border-gray-300 px-3 text-sm text-gray-700 hover:bg-gray-50" data-calendar-action="next">
                            →
                        </button>
                    </div>

                    <h3 class="text-base font-semibold text-gray-900" data-calendar-title>Calendar</h3>

                    <div class="flex flex-wrap items-center gap-2">
                        @foreach ($viewOptions as $value => $label)
                            <button
                                type="button"
                                class="inline-flex h-9 items-center rounded-md border border-gray-300 px-3 text-sm text-gray-700 hover:bg-gray-50"
                                data-calendar-view="{{ $value }}"
                            >
                                {{ $label }}
                            </button>
                        @endforeach
                    </div>
                </div>

                <div class="mb-4 flex flex-wrap items-center gap-2 text-xs">
                    @foreach (($eventTypeLabels ?? []) as $eventType => $eventTypeLabel)
                        <span class="inline-flex items-center gap-1 rounded-full border border-gray-200 bg-gray-50 px-2.5 py-1 text-gray-700">
                            <span class="h-2.5 w-2.5 rounded-full" style="background-color: {{ $eventTypeColors[$eventType] ?? '#475569' }}"></span>
                            <span>{{ $eventTypeLabel }}</span>
                        </span>
                    @endforeach
                </div>

                <div class="mb-4 flex flex-wrap items-center gap-2 text-xs">
                    @foreach ($statusLabels as $status => $label)
                        <span class="inline-flex items-center gap-1 rounded-full border border-gray-200 bg-gray-50 px-2.5 py-1 text-gray-700">
                            <span class="h-2.5 w-2.5 rounded-full" style="background-color: {{ $statusColors[$status] ?? '#475569' }}"></span>
                            <span>{{ $label }}</span>
                        </span>
                    @endforeach
                </div>

                <div
                    data-task-calendar
                    data-events-url="{{ route('calendar.events') }}"
                    data-update-url-template="{{ str_replace('TASK_ID', '__TASK__', route('calendar.tasks.timing', ['task' => 'TASK_ID'])) }}"
                    data-create-url="{{ route('tasks.create') }}"
                    data-initial-view="{{ $initialView }}"
                    class="rounded-lg border border-gray-200 p-2"
                >
                    <div class="text-sm text-gray-500">Loading the calendar...</div>
                </div>
            </section>
        </div>
    </div>
</x-app-layout>
