# CRM25 Server Install

Поддерживаемый сценарий:
- чистый Linux-сервер на Debian/Ubuntu с `apt`
- запуск от `root`
- во время установки задается только домен
- если домен не введен, CRM ставится на текущий публичный IP

Что делает инсталлятор:
- скачивает актуальный релиз CRM25 из `update.crm25.webnet.kz`
- устанавливает `nginx`, `php-fpm`, `mysql`, `redis`, `supervisor`, `cron`
- создает и настраивает MySQL-базу и Redis
- настраивает `.env`
- выполняет миграции
- создает стартового администратора и дефолтную воронку сделок
- собирает frontend
- настраивает `queue:work`, `reverb:start` и `schedule:run`
- при домене пытается выпустить Let's Encrypt сертификат

Запуск с локального файла:

```bash
sudo bash scripts/install-crm25.sh
```

One-liner с сервера обновлений:

```bash
curl -fsSL https://update.crm25.webnet.kz/install.sh | sudo bash
```

Запуск без вопроса о домене:

```bash
sudo CRM25_DOMAIN=crm.example.com bash scripts/install-crm25.sh
```

Принудительная переустановка в уже занятый каталог:

```bash
sudo CRM25_INSTALL_FORCE=1 bash scripts/install-crm25.sh
```

После завершения:
- URL CRM будет выведен в консоль
- учетные данные администратора будут сохранены в `/root/crm25-install-credentials.txt`

Ограничения:
- если домен не указывает на сервер, HTTPS не выпустится, установка продолжится по HTTP
- для первой установки нужен доступ сервера в интернет: `apt`, `npm`, `update.crm25.webnet.kz`
