<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table): void {
            $table->string('remote_access_username')->nullable()->after('remote_access_address');
            $table->unsignedSmallInteger('remote_access_port')->nullable()->after('remote_access_username');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table): void {
            $table->dropColumn([
                'remote_access_username',
                'remote_access_port',
            ]);
        });
    }
};
