<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table): void {
            $table->string('remote_access_provider', 50)->nullable()->after('start_page');
            $table->string('remote_access_address')->nullable()->after('remote_access_provider');
            $table->string('remote_access_password')->nullable()->after('remote_access_address');
            $table->string('remote_access_launch_url')->nullable()->after('remote_access_password');
            $table->text('remote_access_notes')->nullable()->after('remote_access_launch_url');
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table): void {
            $table->dropColumn([
                'remote_access_provider',
                'remote_access_address',
                'remote_access_password',
                'remote_access_launch_url',
                'remote_access_notes',
            ]);
        });
    }
};
