<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('remote_access_requests', function (Blueprint $table): void {
            $table->id();
            $table->foreignId('requester_id')->constrained('users')->cascadeOnDelete();
            $table->foreignId('recipient_id')->constrained('users')->cascadeOnDelete();
            $table->string('status', 32)->default('requested');
            $table->text('request_message')->nullable();
            $table->text('response_message')->nullable();
            $table->timestamp('requested_at')->nullable();
            $table->timestamp('resolved_at')->nullable();
            $table->timestamps();

            $table->index(['recipient_id', 'status', 'created_at']);
            $table->index(['requester_id', 'status', 'created_at']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('remote_access_requests');
    }
};
