<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('messenger_settings', function (Blueprint $table): void {
            $table->json('allowed_operator_ids')->nullable()->after('account_id');
            $table->boolean('auto_create_contact')->default(true)->after('allowed_operator_ids');
            $table->string('new_contact_action', 20)->default('none')->after('auto_create_contact');
            $table->foreignId('new_contact_action_user_id')->nullable()->after('new_contact_action')->constrained('users')->nullOnDelete();
        });

        Schema::table('messenger_conversations', function (Blueprint $table): void {
            $table->foreignId('contact_id')->nullable()->after('contact_handle')->constrained('contacts')->nullOnDelete();
            $table->index('contact_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('messenger_conversations', function (Blueprint $table): void {
            $table->dropIndex(['contact_id']);
            $table->dropConstrainedForeignId('contact_id');
        });

        Schema::table('messenger_settings', function (Blueprint $table): void {
            $table->dropConstrainedForeignId('new_contact_action_user_id');
            $table->dropColumn([
                'allowed_operator_ids',
                'auto_create_contact',
                'new_contact_action',
            ]);
        });
    }
};

