<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('companies', function (Blueprint $table): void {
            if (! Schema::hasColumn('companies', 'avatar_path')) {
                $table->string('avatar_path')->nullable()->after('notes');
            }
        });

        Schema::table('contacts', function (Blueprint $table): void {
            if (! Schema::hasColumn('contacts', 'avatar_path')) {
                $table->string('avatar_path')->nullable()->after('notes');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('companies', function (Blueprint $table): void {
            if (Schema::hasColumn('companies', 'avatar_path')) {
                $table->dropColumn('avatar_path');
            }
        });

        Schema::table('contacts', function (Blueprint $table): void {
            if (Schema::hasColumn('contacts', 'avatar_path')) {
                $table->dropColumn('avatar_path');
            }
        });
    }
};
