<?php

namespace Database\Factories;

use App\Models\Company;
use App\Models\Contact;
use App\Models\Deal;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Task>
 */
class TaskFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $startsAt = fake()->optional()->dateTimeBetween('-7 days', '+15 days');

        return [
            'title' => fake()->sentence(5),
            'description' => fake()->optional()->paragraph(),
            'deal_id' => Deal::factory(),
            'company_id' => Company::factory(),
            'contact_id' => Contact::factory(),
            'creator_id' => User::factory(),
            'assignee_id' => User::factory(),
            'status' => fake()->randomElement(['todo', 'in_progress', 'review', 'done']),
            'priority' => fake()->randomElement(['low', 'medium', 'high', 'urgent']),
            'starts_at' => $startsAt,
            'due_at' => fake()->optional()->dateTimeBetween($startsAt ?: 'now', '+30 days'),
            'reminder_at' => fake()->optional()->dateTimeBetween('now', '+20 days'),
            'completed_at' => null,
        ];
    }
}
