<?php

declare(strict_types=1);

$data = trim((string) ($_GET['data'] ?? ''));

if ($data === '') {
    http_response_code(400);
    header('Content-Type: text/plain; charset=utf-8');
    echo "Missing data query parameter.\n";
    exit;
}

$payload = http_build_query(['data' => $data], '', '&', PHP_QUERY_RFC3986);
$ch = curl_init('http://127.0.0.1:8090/remote-browser/api/tokens');

curl_setopt_array($ch, [
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $payload,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        'Content-Type: application/x-www-form-urlencoded',
        'Content-Length: '.strlen($payload),
    ],
    CURLOPT_TIMEOUT => 20,
]);

$body = curl_exec($ch);
$httpCode = (int) curl_getinfo($ch, CURLINFO_RESPONSE_CODE);
$curlError = curl_error($ch);
curl_close($ch);

if (! is_string($body) || $body === '') {
    http_response_code(502);
    header('Content-Type: text/plain; charset=utf-8');
    echo "Unable to reach remote browser gateway.\n";
    if ($curlError !== '') {
        echo $curlError."\n";
    }
    exit;
}

$decoded = json_decode($body, true);
if (! is_array($decoded) || $httpCode >= 400) {
    http_response_code(502);
    header('Content-Type: text/plain; charset=utf-8');
    echo "Remote browser gateway authentication failed.\n";
    echo $body."\n";
    exit;
}

$authToken = trim((string) ($decoded['authToken'] ?? ''));
$dataSource = trim((string) ($decoded['dataSource'] ?? ''));

if ($dataSource === '') {
    $dataSource = 'json';
}

if ($authToken === '') {
    http_response_code(502);
    header('Content-Type: text/plain; charset=utf-8');
    echo "Remote browser gateway did not return an auth token.\n";
    exit;
}

$treeCh = curl_init(sprintf(
    'http://127.0.0.1:8090/remote-browser/api/session/data/%s/connectionGroups/ROOT/tree?token=%s',
    rawurlencode($dataSource),
    rawurlencode($authToken)
));

curl_setopt_array($treeCh, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_TIMEOUT => 20,
]);

$treeBody = curl_exec($treeCh);
$treeHttpCode = (int) curl_getinfo($treeCh, CURLINFO_RESPONSE_CODE);
$treeCurlError = curl_error($treeCh);
curl_close($treeCh);

$connectionId = '';
if (is_string($treeBody) && $treeBody !== '' && $treeHttpCode < 400) {
    $tree = json_decode($treeBody, true);
    $firstConnection = is_array($tree['childConnections'] ?? null)
        ? reset($tree['childConnections'])
        : null;

    if (is_array($firstConnection)) {
        $connectionId = trim((string) ($firstConnection['identifier'] ?? ''));
    }
}

$target = '/remote-browser/';
if ($connectionId !== '') {
    $clientIdentifier = rtrim(strtr(base64_encode($connectionId."\0".'c'."\0".$dataSource), '+/', '-_'), '=');
    $target = '/remote-browser/#/client/'.rawurlencode($clientIdentifier).'?token='.rawurlencode($authToken);
} else {
    $target = '/remote-browser/?token='.rawurlencode($authToken);
    if ($treeCurlError !== '') {
        header('X-CRM25-Gateway-Warning: '.substr($treeCurlError, 0, 180));
    }
}

header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Pragma: no-cache');
header('Location: '.$target, true, 302);
