# Browser Remote Gateway

Self-hosted browser gateway for CRM25 remote workstation access.

This component uses:

- Apache Guacamole web application
- `guacd` proxy daemon
- JSON authentication extension
- A small PHP launcher that exchanges signed `data` payloads for a Guacamole token and redirects directly into the browser session

Target deployment:

- host: `update.crm25.webnet.kz`
- Guacamole app: `https://update.crm25.webnet.kz/remote-browser/`
- launcher URL used by CRM: `https://update.crm25.webnet.kz/remote-browser-launch/`

Managed server directory:

- `/var/www/update.crm25.webnet.kz/remote-browser-gateway`

## Install

Run on the target host as root:

```bash
REMOTE_BROWSER_GATEWAY_SECRET="<32 hex chars>" \
bash /var/www/update.crm25.webnet.kz/remote-browser-gateway/bin/install.sh
```

## CRM integration

Set shared gateway settings in CRM `.env`:

```env
REMOTE_BROWSER_GATEWAY_ENABLED=true
REMOTE_BROWSER_GATEWAY_URL=https://update.crm25.webnet.kz/remote-browser-launch/
REMOTE_BROWSER_GATEWAY_SECRET=<same 32 hex chars>
```
