<?php

namespace App\Providers;

use App\Models\User;
use App\Support\AccessControl;
use Illuminate\Support\Facades\Gate;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Gate::define('viewReports', fn (User $user) => AccessControl::allows($user, 'reports', 'read'));
        Gate::define('viewCalendar', fn (User $user) => AccessControl::allows($user, 'calendar', 'read'));
        Gate::define('viewForms', fn (User $user) => AccessControl::allows($user, 'forms', 'read'));
        Gate::define('viewDisk', fn (User $user) => AccessControl::allows($user, 'disks', 'read'));
        Gate::define('accessApi', fn (User $user) => AccessControl::allows($user, 'api', 'read'));
        Gate::define('manageAccess', fn (User $user) => AccessControl::canManageAccess($user));
    }
}
