<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrganizationSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'group_companies_enabled',
        'theme_id',
    ];

    protected function casts(): array
    {
        return [
            'group_companies_enabled' => 'boolean',
            'theme_id' => 'integer',
        ];
    }

    public static function current(): self
    {
        /** @var self $setting */
        $setting = self::query()->firstOrCreate([], [
            'group_companies_enabled' => false,
        ]);

        return $setting;
    }
}
