<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\MessengerConversation */
class MessengerConversationResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'provider' => $this->provider,
            'external_id' => $this->external_id,
            'contact_name' => $this->contact_name,
            'contact_handle' => $this->contact_handle,
            'contact_id' => $this->contact_id,
            'status' => $this->status,
            'last_message_at' => $this->last_message_at,
            'channel' => MessengerChannelResource::make($this->whenLoaded('channel')),
            'user' => UserResource::make($this->whenLoaded('user')),
            'contact' => ContactResource::make($this->whenLoaded('contact')),
            'last_message' => MessengerMessageResource::make($this->whenLoaded('lastMessage')),
            'messages_count' => $this->whenCounted('messages'),
            'meta' => $this->meta,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
