<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

/** @mixin \App\Models\Mailbox */
class MailboxResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'user_id' => $this->user_id,
            'address' => $this->address,
            'local_part' => $this->local_part,
            'domain' => $this->domain,
            'status' => $this->status,
            'is_primary' => (bool) $this->is_primary,
            'quota_mb' => (int) ($this->quota_mb ?? 0),
            'used_mb' => (int) ($this->used_mb ?? 0),
            'forward_to' => $this->forward_to,
            'meta' => $this->meta,
            'provisioned_at' => $this->provisioned_at,
            'user' => UserResource::make($this->whenLoaded('user')),
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}

