@php
    $dealStatusLabels = [
        'open' => __('Open'),
        'won' => __('Won'),
        'lost' => __('Lost'),
    ];

    $dealPriorityLabels = [
        'low' => __('Low'),
        'medium' => __('Medium'),
        'high' => __('High'),
    ];
@endphp

<div class="space-y-4 p-5" data-sidepanel-entity="deal">
    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <h3 class="text-base font-semibold text-slate-900">{{ $deal->title }}</h3>
        <p class="text-sm text-slate-500">{{ $deal->pipeline?->name }} · {{ $deal->stage?->name }}</p>

        <dl class="mt-4 grid grid-cols-1 gap-3 text-sm sm:grid-cols-2">
            <div>
                <dt class="text-slate-500">Sum</dt>
                <dd class="text-slate-900">${{ number_format((float) $deal->amount, 0, '.', ' ') }} {{ $deal->currency }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Status</dt>
                <dd class="text-slate-900">{{ $dealStatusLabels[$deal->status] ?? $deal->status }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Priority</dt>
                <dd class="text-slate-900">{{ $dealPriorityLabels[$deal->priority] ?? $deal->priority }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Closing plan</dt>
                <dd class="text-slate-900">{{ $deal->expected_close_at?->format('d.m.Y') ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Company</dt>
                <dd class="text-slate-900">{{ $deal->company?->name ?: '—' }}</dd>
            </div>
            <div>
                <dt class="text-slate-500">Contact</dt>
                <dd class="text-slate-900">{{ $deal->contact?->full_name ?: '—' }}</dd>
            </div>
        </dl>

        <div class="mt-4">
            <p class="text-xs font-medium uppercase tracking-wide text-slate-500">Description</p>
            <p class="mt-1 whitespace-pre-line text-sm text-slate-900">{{ $deal->description ?: 'No description' }}</p>
        </div>
    </section>

    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <h4 class="mb-3 text-sm font-semibold text-slate-900">Tasks ({{ $deal->tasks->count() }})</h4>
        <div class="space-y-2">
            @forelse ($deal->tasks->take(8) as $task)
                <a href="{{ route('tasks.show', $task) }}" class="block rounded-lg border border-slate-200 px-3 py-2 hover:bg-slate-50">
                    <p class="text-sm font-medium text-slate-900">#{{ $task->id }} · {{ $task->title }}</p>
                    <p class="text-xs text-slate-500">{{ strtoupper($task->status) }} · {{ $task->assignee?->name ?? '—' }}</p>
                </a>
            @empty
                <p class="text-sm text-slate-500">There are no tasks yet.</p>
            @endforelse
        </div>
    </section>

    <section class="rounded-xl border border-slate-200 bg-white p-4">
        <h4 class="mb-3 text-sm font-semibold text-slate-900">Activities ({{ $deal->activities->count() }})</h4>
        <div class="space-y-2">
            @forelse ($deal->activities->take(8) as $activity)
                <a href="{{ route('activities.show', $activity) }}" data-sidepanel="off" class="block rounded-lg border border-slate-200 px-3 py-2 hover:bg-slate-50">
                    <p class="text-sm font-medium text-slate-900">{{ $activity->subject }}</p>
                    <p class="text-xs text-slate-500">{{ strtoupper($activity->type) }} · {{ $activity->occurred_at?->format('d.m H:i') }}</p>
                </a>
            @empty
                <p class="text-sm text-slate-500">There are no activities yet.</p>
            @endforelse
        </div>
    </section>

    <div class="flex items-center gap-2">
        <a href="{{ route('deals.show', $deal) }}" data-sidepanel="off" class="inline-flex items-center rounded-md border border-slate-300 px-3 py-2 text-sm font-medium text-slate-700 hover:bg-slate-50">
            Open card
        </a>
        <a href="{{ route('deals.edit', $deal) }}" data-sidepanel="off" class="inline-flex items-center rounded-md bg-indigo-600 px-3 py-2 text-sm font-medium text-white hover:bg-indigo-500">
            Edit
        </a>
    </div>
</div>
