@php
    $settingsSection = isset($settingsSection) && is_string($settingsSection) ? $settingsSection : null;
    $profileUpdateRouteParams = $settingsSection ? ['section' => $settingsSection] : [];
    $currentLocale = old('locale', $user->locale ?? app()->getLocale());
@endphp

<section>
    <header>
        <h2 class="text-lg font-medium text-gray-900">{{ __('Localization') }}</h2>
        <p class="mt-1 text-sm text-gray-600">{{ __('Setting the CRM interface language.') }}</p>
    </header>

    <form method="post" action="{{ route('profile.update', $profileUpdateRouteParams) }}" class="mt-6 space-y-4">
        @csrf
        @method('patch')
        @if ($settingsSection)
            <input type="hidden" name="_settings_section" value="{{ $settingsSection }}">
        @endif

        <input type="hidden" name="name" value="{{ $user->name }}">
        <input type="hidden" name="email" value="{{ $user->email }}">

        <div class="space-y-2">
            <x-input-label :value="__('Language')" />

            <div class="flex flex-wrap items-center gap-3">
                <button
                    type="submit"
                    name="locale"
                    value="en"
                    class="inline-flex items-center rounded-md border px-4 py-2 text-sm font-medium transition {{ $currentLocale === 'en' ? 'border-indigo-300 bg-indigo-50 text-indigo-700' : 'border-slate-300 bg-white text-slate-700 hover:border-indigo-300 hover:bg-indigo-50 hover:text-indigo-700' }}"
                >
                    {{ __('English') }}
                </button>

                <button
                    type="submit"
                    name="locale"
                    value="ru"
                    class="inline-flex items-center rounded-md border px-4 py-2 text-sm font-medium transition {{ $currentLocale === 'ru' ? 'border-indigo-300 bg-indigo-50 text-indigo-700' : 'border-slate-300 bg-white text-slate-700 hover:border-indigo-300 hover:bg-indigo-50 hover:text-indigo-700' }}"
                >
                    {{ __('Russian') }}
                </button>
            </div>

            <x-input-error class="mt-2" :messages="$errors->get('locale')" />
        </div>

        @if (session('status') === 'profile-updated')
            <p
                x-data="{ show: true }"
                x-show="show"
                x-transition
                x-init="setTimeout(() => show = false, 1200)"
                class="text-sm text-gray-600"
            >{{ __('Saved.') }}</p>
        @endif
    </form>
</section>
