<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Sales funnels</h2>
            <div class="flex items-center gap-2">
                @include('partials.section-access-controls', [
                    'sectionAccessEntity' => 'pipelines',
                    'sectionAccessTitle' => __('Pipelines'),
                    'canManageSectionAccess' => $canManageSectionAccess ?? false,
                    'sectionAccessUsers' => $sectionAccessUsers ?? collect(),
                ])
                <a href="{{ route('pipelines.create') }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">New funnel</a>
            </div>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6">
            <div class="grid grid-cols-1 lg:grid-cols-2 gap-4">
                @forelse ($pipelines as $pipeline)
                    <div class="bg-white border border-gray-200 rounded-xl p-5">
                        <div class="flex items-start justify-between gap-4">
                            <div>
                                <h3 class="text-lg font-semibold text-gray-900">{{ $pipeline->name }}</h3>
                                <p class="text-sm text-gray-500 mt-1">{{ $pipeline->description ?: 'No description' }}</p>
                            </div>

                            <div class="flex gap-2">
                                @if ($pipeline->is_default)
                                    <span class="rounded bg-indigo-100 px-2 py-1 text-xs font-medium text-indigo-700">Default</span>
                                @endif
                                @if (! $pipeline->is_active)
                                    <span class="rounded bg-gray-100 px-2 py-1 text-xs font-medium text-gray-700">Inactive</span>
                                @endif
                            </div>
                        </div>

                        <div class="mt-4 grid grid-cols-2 gap-4 text-sm">
                            <div class="rounded-lg bg-gray-50 p-3 border border-gray-100">
                                <p class="text-gray-500">Stages</p>
                                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $pipeline->stages->count() }}</p>
                            </div>
                            <div class="rounded-lg bg-gray-50 p-3 border border-gray-100">
                                <p class="text-gray-500">Transactions</p>
                                <p class="mt-1 text-lg font-semibold text-gray-900">{{ $pipeline->deals->count() }}</p>
                            </div>
                        </div>

                        <div class="mt-4">
                            <p class="text-xs text-gray-500 mb-2">Stages</p>
                            <div class="flex flex-wrap gap-2">
                                @foreach ($pipeline->stages->sortBy('sort_order') as $stage)
                                    <span class="rounded-md border border-gray-200 bg-white px-2 py-1 text-xs text-gray-700">{{ $stage->name }}</span>
                                @endforeach
                            </div>
                        </div>

                        <div class="mt-5 flex items-center justify-end gap-3">
                            <a href="{{ route('deals.index', ['pipeline_id' => $pipeline->id]) }}" class="text-sm text-gray-600 hover:text-gray-900">Open trades</a>
                            <a href="{{ route('pipelines.edit', $pipeline) }}" class="inline-flex items-center rounded-md bg-gray-800 px-3 py-2 text-sm font-medium text-white hover:bg-gray-700">Edit</a>
                        </div>
                    </div>
                @empty
                    <div class="lg:col-span-2 bg-white border border-gray-200 rounded-xl p-8 text-center text-sm text-gray-500">
                        Funnels have not yet been created.
                    </div>
                @endforelse
            </div>
        </div>
    </div>
</x-app-layout>
