<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>{{ $form->name }} · {{ config('app.name', 'CRM') }}</title>
    <link rel="icon" type="image/png" href="{{ asset('logo_crm25.png') }}">
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @php
        $styleCssVars = $styleCssVars ?? '';
        $styleFontUrl = $styleFontUrl ?? '';
        $styleCustomCss = $styleCustomCss ?? '';
    @endphp
    @if ($styleFontUrl)
        <link rel="stylesheet" href="{{ $styleFontUrl }}">
    @endif
    <style>
        .public-form-page {
            background-color: var(--form-page-bg);
            color: var(--form-text);
            font-family: var(--form-font-family);
        }
        .public-form-container {
            max-width: var(--form-max-width);
        }
        .public-form-card {
            background-color: var(--form-card-bg);
            border-color: var(--form-border);
            border-radius: var(--form-card-radius);
        }
        .public-form-title {
            color: var(--form-text);
        }
        .public-form-muted {
            color: var(--form-muted);
        }
        .public-form-input {
            background-color: var(--form-input-bg);
            border-color: var(--form-input-border);
            border-radius: var(--form-input-radius);
            color: var(--form-input-text);
        }
        .public-form-input:focus {
            border-color: var(--form-primary);
            box-shadow: 0 0 0 3px var(--form-primary-ring);
            outline: none;
        }
        .public-form-button {
            background-color: var(--form-primary);
            color: var(--form-button-text);
            border-radius: var(--form-button-radius);
        }
        .public-form-button:hover {
            background-color: var(--form-primary-hover);
        }
        .public-form-reset {
            background-color: var(--form-reset-bg);
            color: var(--form-reset-text);
            border-color: var(--form-input-border);
            border-radius: var(--form-button-radius);
        }
        {!! $styleCustomCss !!}
    </style>
</head>
<body class="public-form-page min-h-screen antialiased" style="{{ $styleCssVars }}">
    <div class="public-form-container mx-auto flex min-h-screen w-full items-center px-4 py-8">
        <div class="public-form-card w-full border p-6 shadow-sm">
            @php
                $isSubmissionLocked = (bool) ($isSubmissionLocked ?? false);
            @endphp

            <div class="mb-5 border-b border-slate-200 pb-4">
                <h1 class="public-form-title text-xl font-semibold">{{ $form->name }}</h1>
                @if ($form->description)
                    <p class="public-form-muted mt-2 text-sm">{{ $form->description }}</p>
                @endif
            </div>

            @if (session('form_success'))
                <div class="mb-4 rounded-md border border-emerald-200 bg-emerald-50 px-3 py-2 text-sm text-emerald-800">
                    {{ session('form_success') }}
                </div>
            @endif

            @if ($errors->has('form'))
                <div class="mb-4 rounded-md border border-rose-200 bg-rose-50 px-3 py-2 text-sm text-rose-800">
                    {{ $errors->first('form') }}
                </div>
            @endif

            @if ($isSubmissionLocked)
                <div class="rounded-md border border-slate-200 bg-slate-50 px-3 py-2 text-sm text-slate-700">
                    {{ __('This form has already been submitted from this browser session.') }}
                </div>
            @else
                <form method="POST" action="{{ route('public-forms.submit', ['form' => $form->slug]) }}" class="space-y-4">
                    @csrf

                    @foreach (($form->fields ?? []) as $field)
                        @php
                            $name = (string) ($field['name'] ?? '');
                            $label = (string) ($field['label'] ?? $name);
                            $type = (string) ($field['type'] ?? 'text');
                            $required = (bool) ($field['required'] ?? false);
                            $placeholder = (string) ($field['placeholder'] ?? '');
                            $options = is_array($field['options'] ?? null) ? $field['options'] : [];
                        @endphp

                        @continue($name === '')

                        <div>
                            <label for="field-{{ $name }}" class="mb-1 block text-sm font-medium">
                                {{ $label }}
                                @if ($required)
                                    <span class="text-rose-600">*</span>
                                @endif
                            </label>

                            @if ($type === 'textarea')
                                <textarea
                                    id="field-{{ $name }}"
                                    name="{{ $name }}"
                                    rows="4"
                                    @if ($required) required @endif
                                    class="public-form-input block w-full text-sm shadow-sm"
                                    placeholder="{{ $placeholder }}"
                                >{{ old($name) }}</textarea>
                            @elseif ($type === 'select')
                                <select
                                    id="field-{{ $name }}"
                                    name="{{ $name }}"
                                    @if ($required) required @endif
                                    class="public-form-input block w-full text-sm shadow-sm"
                                >
                                    <option value="">Select...</option>
                                    @foreach ($options as $option)
                                        <option value="{{ $option }}" @selected(old($name) === $option)>{{ $option }}</option>
                                    @endforeach
                                </select>
                            @elseif ($type === 'checkbox')
                                <label class="inline-flex items-center gap-2 text-sm">
                                    <input type="hidden" name="{{ $name }}" value="0">
                                    <input
                                        id="field-{{ $name }}"
                                        type="checkbox"
                                        name="{{ $name }}"
                                        value="1"
                                        @checked((bool) old($name))
                                        class="rounded border-slate-300 text-indigo-600 shadow-sm focus:ring-indigo-500"
                                    >
                                    <span>{{ $label }}</span>
                                </label>
                            @else
                                @php
                                    $htmlType = match ($type) {
                                        'email' => 'email',
                                        'number' => 'number',
                                        'date' => 'date',
                                        'datetime' => 'datetime-local',
                                        default => 'text',
                                    };
                                    $inputMode = $type === 'phone' ? 'tel' : null;
                                @endphp
                                <input
                                    id="field-{{ $name }}"
                                    type="{{ $htmlType }}"
                                    name="{{ $name }}"
                                    value="{{ old($name) }}"
                                    @if ($required) required @endif
                                    @if ($inputMode) inputmode="{{ $inputMode }}" @endif
                                    class="public-form-input block w-full text-sm shadow-sm"
                                    placeholder="{{ $placeholder }}"
                                >
                            @endif

                            <x-input-error class="mt-2" :messages="$errors->get($name)" />
                        </div>
                    @endforeach

                    <div class="flex items-center gap-3 pt-2">
                        <button type="submit" class="public-form-button inline-flex items-center px-4 py-2 text-sm font-medium">
                            {{ $form->submit_label ?: 'Submit' }}
                        </button>

                        @if ($form->show_reset_button)
                            <button type="reset" class="public-form-reset inline-flex items-center border px-4 py-2 text-sm font-medium">
                                {{ $form->reset_label ?: 'Clear' }}
                            </button>
                        @endif
                    </div>
                </form>
            @endif
        </div>
    </div>
</body>
</html>
