@php
    $supportedHooks = isset($supportedHooks) && is_array($supportedHooks) ? $supportedHooks : \App\Support\CrmModuleManager::supportedHooks();
@endphp

<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-3">
            <h2 class="text-xl font-semibold leading-tight text-gray-800">
                {{ __('Custom Modules Documentation') }}
            </h2>
            <div class="flex items-center gap-2">
                <a
                    href="{{ route('profile.edit', ['section' => 'modules']) }}"
                    class="inline-flex items-center rounded-md border border-slate-300 px-3 py-1.5 text-sm font-medium text-slate-700 transition hover:border-slate-400 hover:text-slate-900"
                >
                    {{ __('Return to modules settings') }}
                </a>
                <a
                    href="{{ route('docs.modules') }}"
                    class="inline-flex items-center rounded-md border border-sky-200 bg-sky-50 px-3 py-1.5 text-sm font-medium text-sky-700 transition hover:border-sky-300 hover:bg-sky-100"
                    target="_blank"
                    rel="noopener"
                >
                    {{ __('Open docs/modules.md') }}
                </a>
            </div>
        </div>
    </x-slot>

    <div class="py-6">
        <div class="w-full px-6">
            <div class="grid grid-cols-1 gap-6 xl:grid-cols-[18rem_minmax(0,1fr)]">
                <aside class="xl:sticky xl:top-6 xl:self-start">
                    <div class="rounded-lg border border-slate-200 bg-white p-4 shadow-sm">
                        <h3 class="text-xs font-semibold uppercase tracking-wide text-slate-500">{{ __('Sections') }}</h3>
                        <nav class="mt-3 space-y-1 text-sm">
                            <a href="#overview" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">{{ __('Overview') }}</a>
                            <a href="#manifest" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">{{ __('module.json') }}</a>
                            <a href="#hooks" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">{{ __('Hooks') }}</a>
                            <a href="#example" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">{{ __('ZIP example') }}</a>
                            <a href="#lifecycle" class="block rounded-md px-2 py-1.5 text-slate-700 hover:bg-slate-100 hover:text-slate-900">{{ __('Lifecycle') }}</a>
                        </nav>
                    </div>
                </aside>

                <div class="space-y-6">
                    <section id="overview" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">{{ __('Overview') }}</h3>
                        <p class="mt-2 text-sm text-slate-700">
                            {{ __('CRM modules are ZIP archives with module.json and PHP hook scripts. After installation a module can modify validated payload of all supported CRM entities before saving.') }}
                        </p>
                        <p class="mt-2 text-sm text-slate-700">
                            {{ __('Install and manage modules in settings: Profile -> Modules.') }}
                        </p>
                    </section>

                    <section id="manifest" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">module.json</h3>
                        <p class="mt-2 text-sm text-slate-700">{{ __('Required root file in archive.') }}</p>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                module.json
                            </div>
                            <pre class="overflow-x-auto p-3 text-xs text-slate-800"><code>{
  "name": "Priority Automation",
  "slug": "priority-automation",
  "version": "1.0.0",
  "description": "Force task priority and fill deal source",
  "hooks": {
    "companies.store": "hooks/companies-store.php",
    "companies.update": "hooks/companies-update.php",
    "tasks.store": "hooks/tasks-store.php",
    "tasks.update": "hooks/tasks-update.php",
    "deals.store": "hooks/deals-store.php",
    "deals.update": "hooks/deals-update.php"
  }
}</code></pre>
                        </div>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <table class="min-w-full divide-y divide-slate-200">
                                <thead class="bg-slate-100">
                                    <tr>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Field') }}</th>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Required') }}</th>
                                        <th class="px-3 py-2 text-left text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Description') }}</th>
                                    </tr>
                                </thead>
                                <tbody class="divide-y divide-slate-100">
                                    <tr>
                                        <td class="px-3 py-2 text-xs text-slate-800"><code>name</code></td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('Yes') }}</td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('Module title in CRM settings.') }}</td>
                                    </tr>
                                    <tr>
                                        <td class="px-3 py-2 text-xs text-slate-800"><code>slug</code></td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('Yes') }}</td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('Unique ID: lowercase latin letters, digits, dots, underscores, dashes.') }}</td>
                                    </tr>
                                    <tr>
                                        <td class="px-3 py-2 text-xs text-slate-800"><code>version</code></td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('No') }}</td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('Version label, default 1.0.0.') }}</td>
                                    </tr>
                                    <tr>
                                        <td class="px-3 py-2 text-xs text-slate-800"><code>description</code></td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('No') }}</td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('Module description in UI.') }}</td>
                                    </tr>
                                    <tr>
                                        <td class="px-3 py-2 text-xs text-slate-800"><code>hooks</code></td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('No') }}</td>
                                        <td class="px-3 py-2 text-xs text-slate-700">{{ __('Map hook name -> relative PHP file path.') }}</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </section>

                    <section id="hooks" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">{{ __('Supported hooks') }}</h3>
                        <div class="mt-3 flex flex-wrap gap-1">
                            @foreach ($supportedHooks as $hook)
                                <code class="rounded bg-slate-100 px-2 py-1 text-xs text-slate-800">{{ $hook }}</code>
                            @endforeach
                        </div>

                        <p class="mt-4 text-sm text-slate-700">{{ __('Hook script can return either array or callable(payload, context, manifest). Returned array is merged into entity payload before saving.') }}</p>

                        <div class="mt-4 overflow-hidden rounded-lg border border-slate-200 bg-white">
                            <div class="border-b border-slate-200 bg-slate-100 px-3 py-2 text-xs font-semibold uppercase tracking-wide text-slate-600">
                                hooks/tasks-store.php
                            </div>
                            <pre class="overflow-x-auto p-3 text-xs text-slate-800"><code>&lt;?php

return static function (array $payload, array $context, array $manifest): array {
    if (($payload['priority'] ?? '') === 'low') {
        $payload['priority'] = 'high';
    }

    if (empty($payload['source']) && ($context['hook'] ?? '') === 'deals.store') {
        $payload['source'] = 'module-default';
    }

    return $payload;
};</code></pre>
                        </div>
                    </section>

                    <section id="example" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">{{ __('ZIP example') }}</h3>
                        <p class="mt-2 text-sm text-slate-700">{{ __('Archive structure must look like this (module.json in root):') }}</p>
                        <pre class="mt-3 overflow-x-auto rounded-lg border border-slate-200 bg-slate-50 p-3 text-xs text-slate-800"><code>priority-automation.zip
├── module.json
├── README.md
└── hooks
    ├── companies-store.php
    ├── companies-update.php
    ├── tasks-store.php
    ├── tasks-update.php
    ├── deals-store.php
    └── deals-update.php</code></pre>
                    </section>

                    <section id="lifecycle" class="scroll-mt-24 rounded-lg border border-slate-200 bg-white p-5 shadow-sm">
                        <h3 class="text-lg font-semibold text-slate-900">{{ __('Lifecycle') }}</h3>
                        <ol class="mt-3 list-decimal space-y-2 pl-5 text-sm text-slate-700">
                            <li>{{ __('Create scaffold ZIP in settings.') }}</li>
                            <li>{{ __('Implement hooks and pack files to ZIP.') }}</li>
                            <li>{{ __('Upload archive in settings -> Modules.') }}</li>
                            <li>{{ __('Enable/disable module with a single click.') }}</li>
                            <li>{{ __('Upload a new ZIP with same slug to update module version.') }}</li>
                        </ol>
                    </section>
                </div>
            </div>
        </div>
    </div>
</x-app-layout>
