@php
    $deal = $deal ?? null;
    $selectedPipelineId = (int) old('pipeline_id', request('pipeline_id', $deal?->pipeline_id ?? $selectedPipeline?->id));
    $selectedStageId = (int) old('stage_id', $deal?->stage_id ?? ($selectedPipeline?->stages->first()?->id));
    $stageMap = $pipelines->mapWithKeys(fn ($pipeline) => [
        $pipeline->id => $pipeline->stages->map(fn ($stage) => ['id' => $stage->id, 'name' => $stage->name])->values(),
    ]);
@endphp

<div class="grid grid-cols-1 md:grid-cols-2 gap-4">
    <div class="md:col-span-2">
        <label for="title" class="block text-sm font-medium text-gray-700">Trade name</label>
        <input id="title" name="title" type="text" required value="{{ old('title', $deal?->title) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="pipeline_id" class="block text-sm font-medium text-gray-700">Funnel</label>
        <select id="pipeline_id" name="pipeline_id" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach ($pipelines as $pipeline)
                <option value="{{ $pipeline->id }}" @selected($selectedPipelineId === $pipeline->id)>{{ $pipeline->name }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="stage_id" class="block text-sm font-medium text-gray-700">Stage</label>
        <select id="stage_id" name="stage_id" required data-selected="{{ $selectedStageId }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (($pipelines->firstWhere('id', $selectedPipelineId)?->stages ?? collect()) as $stage)
                <option value="{{ $stage->id }}" @selected($selectedStageId === $stage->id)>{{ $stage->name }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="company_id" class="block text-sm font-medium text-gray-700">Company</label>
        <select id="company_id" name="company_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            <option value="">Without company</option>
            @foreach ($companies as $company)
                <option value="{{ $company->id }}" @selected((int) old('company_id', request('company_id', $deal?->company_id)) === $company->id)>{{ $company->name }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="contact_id" class="block text-sm font-medium text-gray-700">Contact</label>
        <select id="contact_id" name="contact_id" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            <option value="">No contact</option>
            @foreach ($contacts as $contact)
                <option value="{{ $contact->id }}" @selected((int) old('contact_id', request('contact_id', $deal?->contact_id)) === $contact->id)>{{ $contact->full_name ?: $contact->first_name }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="owner_id" class="block text-sm font-medium text-gray-700">Responsible</label>
        <x-user-search-select
            id="owner_id"
            name="owner_id"
            :users="$owners"
            :selected="old('owner_id', $deal?->owner_id)"
            placeholder="Finding the person responsible"
            empty-label="Not assigned"
        />
    </div>

    <div>
        <label for="amount" class="block text-sm font-medium text-gray-700">Sum</label>
        <input id="amount" name="amount" type="number" min="0" step="0.01" required value="{{ old('amount', $deal?->amount ?? 0) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="currency" class="block text-sm font-medium text-gray-700">Currency</label>
        <input id="currency" name="currency" type="text" maxlength="3" required value="{{ old('currency', $deal?->currency ?? 'USD') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500 uppercase">
    </div>

    <div>
        <label for="priority" class="block text-sm font-medium text-gray-700">Priority</label>
        <select id="priority" name="priority" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (['low' => 'Low', 'medium' => 'Medium', 'high' => 'Tall'] as $value => $label)
                <option value="{{ $value }}" @selected(old('priority', $deal?->priority ?? 'medium') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="status" class="block text-sm font-medium text-gray-700">Status</label>
        <select id="status" name="status" required class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
            @foreach (['open' => 'Open', 'won' => 'Won', 'lost' => 'Lost'] as $value => $label)
                <option value="{{ $value }}" @selected(old('status', $deal?->status ?? 'open') === $value)>{{ $label }}</option>
            @endforeach
        </select>
    </div>

    <div>
        <label for="expected_close_at" class="block text-sm font-medium text-gray-700">Closing plan</label>
        <input id="expected_close_at" name="expected_close_at" type="date" value="{{ old('expected_close_at', $deal?->expected_close_at?->format('Y-m-d')) }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>

    <div>
        <label for="source" class="block text-sm font-medium text-gray-700">Source</label>
        <input id="source" name="source" type="text" value="{{ old('source', $deal?->source ?? 'manual') }}" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
    </div>
</div>

<div class="mt-4">
    <label for="lost_reason" class="block text-sm font-medium text-gray-700">Reason for loss</label>
    <textarea id="lost_reason" name="lost_reason" rows="2" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('lost_reason', $deal?->lost_reason) }}</textarea>
</div>

<div class="mt-4">
    <label for="description" class="block text-sm font-medium text-gray-700">Description</label>
    <textarea id="description" name="description" rows="4" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">{{ old('description', $deal?->description) }}</textarea>
</div>

<script>
    document.addEventListener('DOMContentLoaded', () => {
        const stageMap = @json($stageMap);
        const pipelineSelect = document.getElementById('pipeline_id');
        const stageSelect = document.getElementById('stage_id');

        if (!pipelineSelect || !stageSelect) {
            return;
        }

        const renderStages = () => {
            const pipelineId = pipelineSelect.value;
            const stages = stageMap[pipelineId] || [];
            const selected = stageSelect.dataset.selected || stageSelect.value;

            stageSelect.innerHTML = '';

            stages.forEach((stage) => {
                const option = document.createElement('option');
                option.value = stage.id;
                option.textContent = stage.name;
                if (String(stage.id) === String(selected)) {
                    option.selected = true;
                }
                stageSelect.appendChild(option);
            });

            if (stageSelect.options.length === 0) {
                const option = document.createElement('option');
                option.value = '';
                option.textContent = 'No stages';
                stageSelect.appendChild(option);
            }

            stageSelect.dataset.selected = stageSelect.value;
        };

        pipelineSelect.addEventListener('change', () => {
            stageSelect.dataset.selected = '';
            renderStages();
        });

        stageSelect.addEventListener('change', () => {
            stageSelect.dataset.selected = stageSelect.value;
        });

        renderStages();
    });
</script>
