<x-app-layout>
    <x-slot name="header">
        <div class="flex items-center justify-between gap-4">
            <h2 class="font-semibold text-xl text-gray-800 leading-tight">Activities</h2>
            <a href="{{ route('activities.create') }}" class="inline-flex items-center rounded-md bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-500">Add activity</a>
        </div>
    </x-slot>

    <div class="pb-12">
        <div class="w-full px-6 space-y-4">
            <div class="bg-white border border-gray-200 rounded-xl p-4">
                <form method="GET" action="{{ route('activities.index') }}" class="grid grid-cols-1 md:grid-cols-3 gap-3">
                    <div>
                        <label for="type" class="block text-xs font-medium text-gray-500 uppercase">Type</label>
                        <select id="type" name="type" class="mt-1 w-full rounded-md border-gray-300 shadow-sm focus:border-indigo-500 focus:ring-indigo-500">
                            <option value="">All</option>
                            @foreach (['call', 'email', 'meeting', 'note', 'task_update'] as $value)
                                <option value="{{ $value }}" @selected($type === $value)>{{ strtoupper($value) }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div>
                        <label for="user_id" class="block text-xs font-medium text-gray-500 uppercase">User</label>
                        <x-user-search-select
                            id="user_id"
                            name="user_id"
                            :users="$users"
                            :selected="$userId"
                            placeholder="All users"
                            empty-label="All"
                        />
                    </div>

                    <div class="flex items-end">
                        <button type="submit" class="inline-flex items-center rounded-md bg-gray-800 px-4 py-2 text-sm font-medium text-white hover:bg-gray-700">Filter</button>
                    </div>
                </form>
            </div>

            <div class="bg-white border border-gray-200 rounded-xl overflow-hidden">
                <table class="min-w-full divide-y divide-gray-200">
                    <thead class="bg-gray-50">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Activity</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Connection</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">User</th>
                            <th class="px-4 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-gray-100 bg-white">
                        @forelse ($activities as $activity)
                            <tr class="hover:bg-gray-50">
                                <td class="px-4 py-3">
                                    <a href="{{ route('activities.show', $activity) }}" class="font-medium text-gray-900 hover:text-indigo-600">{{ $activity->subject }}</a>
                                    <div class="text-xs text-gray-500">{{ strtoupper($activity->type) }} · {{ strtoupper($activity->direction) }}</div>
                                </td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $activity->deal?->title ?? $activity->company?->name ?? $activity->contact?->full_name ?? '—' }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $activity->user?->name ?? 'System' }}</td>
                                <td class="px-4 py-3 text-sm text-gray-700">{{ $activity->occurred_at?->format('d.m.Y H:i') }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="4" class="px-4 py-8 text-center text-sm text-gray-500">No activities found.</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            <div>{{ $activities->links() }}</div>
        </div>
    </div>
</x-app-layout>
