<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('messenger_channels', function (Blueprint $table): void {
            $table->id();
            $table->string('provider')->index();
            $table->string('external_id')->nullable();
            $table->string('name');
            $table->string('handle')->nullable();
            $table->string('status')->default('active')->index();
            $table->boolean('is_default')->default(false)->index();
            $table->json('meta')->nullable();
            $table->timestamps();

            $table->unique(['provider', 'external_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('messenger_channels');
    }
};
