<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table): void {
            $table->json('appearance_settings')->nullable()->after('right_rail_collapsed');
            $table->string('start_page')->nullable()->after('appearance_settings');
            $table->string('background_image_path')->nullable()->after('start_page');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table): void {
            $table->dropColumn(['appearance_settings', 'start_page', 'background_image_path']);
        });
    }
};

