<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (! Schema::hasTable('user_menu_items')) {
            return;
        }

        if (Schema::hasColumn('user_menu_items', 'open_in_new_tab')) {
            return;
        }

        Schema::table('user_menu_items', function (Blueprint $table) {
            $table->boolean('open_in_new_tab')->default(false)->after('is_custom');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (! Schema::hasTable('user_menu_items') || ! Schema::hasColumn('user_menu_items', 'open_in_new_tab')) {
            return;
        }

        Schema::table('user_menu_items', function (Blueprint $table) {
            $table->dropColumn('open_in_new_tab');
        });
    }
};
