<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tasks', function (Blueprint $table) {
            $table->foreignId('project_id')->nullable()->constrained('projects')->nullOnDelete();
            $table->foreignId('project_stage_id')->nullable()->constrained('project_stages')->nullOnDelete();
            $table->decimal('estimated_hours', 8, 2)->default(0);
            $table->decimal('tracked_hours', 8, 2)->default(0);
            $table->unsignedSmallInteger('sort_order')->default(0);

            $table->index(['project_id', 'project_stage_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tasks', function (Blueprint $table) {
            $table->dropIndex(['project_id', 'project_stage_id']);
            $table->dropConstrainedForeignId('project_stage_id');
            $table->dropConstrainedForeignId('project_id');
            $table->dropColumn(['estimated_hours', 'tracked_hours', 'sort_order']);
        });
    }
};
