<?php

namespace Database\Factories;

use App\Models\User;
use App\Models\Warehouse;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Warehouse>
 */
class WarehouseFactory extends Factory
{
    protected $model = Warehouse::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => fake()->company().' warehouse',
            'code' => strtoupper(fake()->bothify('WH-####??')),
            'location' => fake()->city(),
            'capacity' => fake()->randomFloat(2, 10, 10000),
            'status' => fake()->randomElement(['active', 'inactive']),
            'manager_id' => User::factory(),
            'description' => fake()->optional()->sentence(),
            'map_rows' => fake()->numberBetween(6, 12),
            'map_columns' => fake()->numberBetween(8, 16),
        ];
    }
}
