<?php

namespace Database\Factories;

use App\Models\Company;
use App\Models\Contact;
use App\Models\DealStage;
use App\Models\Pipeline;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Deal>
 */
class DealFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'title' => fake()->sentence(4),
            'pipeline_id' => Pipeline::factory(),
            'stage_id' => function (array $attributes): int {
                return DealStage::factory()->create(['pipeline_id' => $attributes['pipeline_id']])->id;
            },
            'company_id' => Company::factory(),
            'contact_id' => Contact::factory(),
            'owner_id' => User::factory(),
            'amount' => fake()->randomFloat(2, 500, 50000),
            'currency' => 'USD',
            'priority' => fake()->randomElement(['low', 'medium', 'high']),
            'status' => fake()->randomElement(['open', 'won', 'lost']),
            'expected_close_at' => fake()->optional()->dateTimeBetween('now', '+60 days'),
            'closed_at' => null,
            'last_activity_at' => fake()->optional()->dateTimeBetween('-14 days', 'now'),
            'source' => fake()->randomElement(['manual', 'website', 'ads', 'referral']),
            'lost_reason' => null,
            'description' => fake()->optional()->paragraph(),
        ];
    }
}
