<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class UpdateSetting extends Model
{
    /** @use HasFactory<\Database\Factories\UpdateSettingFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'feed_url',
        'current_version',
        'channel',
        'is_active',
        'auto_check_enabled',
        'check_interval_minutes',
        'request_timeout_seconds',
        'verify_tls',
        'last_checked_at',
        'last_remote_version',
        'last_remote_build',
        'last_error',
        'meta',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'is_active' => 'boolean',
            'auto_check_enabled' => 'boolean',
            'check_interval_minutes' => 'integer',
            'request_timeout_seconds' => 'integer',
            'verify_tls' => 'boolean',
            'last_checked_at' => 'datetime',
            'meta' => 'array',
        ];
    }

    public function checks(): HasMany
    {
        return $this->hasMany(UpdateCheck::class)
            ->orderByDesc('checked_at')
            ->orderByDesc('id');
    }
}

