<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class MessengerChannel extends Model
{
    /** @use HasFactory<\Database\Factories\MessengerChannelFactory> */
    use HasFactory;

    /**
     * @var list<string>
     */
    protected $fillable = [
        'provider',
        'external_id',
        'name',
        'handle',
        'status',
        'is_default',
        'meta',
    ];

    /**
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'is_default' => 'boolean',
            'meta' => 'array',
        ];
    }

    public function conversations(): HasMany
    {
        return $this->hasMany(MessengerConversation::class, 'channel_id');
    }
}
